/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output from the <a>DescribeClusterParameterGroups</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterParameterGroupsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterParameterGroupsResponse.Builder, DescribeClusterParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeClusterParameterGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ClusterParameterGroup>> PARAMETER_GROUPS_FIELD = SdkField
            .<List<ClusterParameterGroup>> builder(MarshallingType.LIST)
            .memberName("ParameterGroups")
            .getter(getter(DescribeClusterParameterGroupsResponse::parameterGroups))
            .setter(setter(Builder::parameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<ClusterParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterParameterGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            PARAMETER_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<ClusterParameterGroup> parameterGroups;

    private DescribeClusterParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.parameterGroups = builder.parameterGroups;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterGroups() {
        return parameterGroups != null && !(parameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterGroups} method.
     * </p>
     * 
     * @return A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
     */
    public final List<ClusterParameterGroup> parameterGroups() {
        return parameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterGroups() ? parameterGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeClusterParameterGroupsResponse other = (DescribeClusterParameterGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasParameterGroups() == other.hasParameterGroups()
                && Objects.equals(parameterGroups(), other.parameterGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterParameterGroupsResponse").add("Marker", marker())
                .add("ParameterGroups", hasParameterGroups() ? parameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ParameterGroups":
            return Optional.ofNullable(clazz.cast(parameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("ParameterGroups", PARAMETER_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeClusterParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterParameterGroupsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(Collection<ClusterParameterGroup> parameterGroups);

        /**
         * <p>
         * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(ClusterParameterGroup... parameterGroups);

        /**
         * <p>
         * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.ClusterParameterGroup.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.ClusterParameterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.ClusterParameterGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterGroups(List<ClusterParameterGroup>)}.
         * 
         * @param parameterGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.ClusterParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterGroups(java.util.Collection<ClusterParameterGroup>)
         */
        Builder parameterGroups(Consumer<ClusterParameterGroup.Builder>... parameterGroups);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ClusterParameterGroup> parameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterParameterGroupsResponse model) {
            super(model);
            marker(model.marker);
            parameterGroups(model.parameterGroups);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ClusterParameterGroup.Builder> getParameterGroups() {
            List<ClusterParameterGroup.Builder> result = ParameterGroupListCopier.copyToBuilder(this.parameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterGroups(Collection<ClusterParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        @Override
        public final Builder parameterGroups(Collection<ClusterParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ClusterParameterGroup... parameterGroups) {
            parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(Consumer<ClusterParameterGroup.Builder>... parameterGroups) {
            parameterGroups(Stream.of(parameterGroups).map(c -> ClusterParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClusterParameterGroupsResponse build() {
            return new DescribeClusterParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
