/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointAccessResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeEndpointAccessResponse.Builder, DescribeEndpointAccessResponse> {
    private static final SdkField<List<EndpointAccess>> ENDPOINT_ACCESS_LIST_FIELD = SdkField
            .<List<EndpointAccess>> builder(MarshallingType.LIST)
            .memberName("EndpointAccessList")
            .getter(getter(DescribeEndpointAccessResponse::endpointAccessList))
            .setter(setter(Builder::endpointAccessList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAccessList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointAccess> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointAccess::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeEndpointAccessResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ACCESS_LIST_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EndpointAccess> endpointAccessList;

    private final String marker;

    private DescribeEndpointAccessResponse(BuilderImpl builder) {
        super(builder);
        this.endpointAccessList = builder.endpointAccessList;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointAccessList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointAccessList() {
        return endpointAccessList != null && !(endpointAccessList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of endpoints with access to the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointAccessList} method.
     * </p>
     * 
     * @return The list of endpoints with access to the cluster.
     */
    public final List<EndpointAccess> endpointAccessList() {
        return endpointAccessList;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by the
     * <code>MaxRecords</code> parameter.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by the <code>MaxRecords</code> parameter.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointAccessList() ? endpointAccessList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointAccessResponse)) {
            return false;
        }
        DescribeEndpointAccessResponse other = (DescribeEndpointAccessResponse) obj;
        return hasEndpointAccessList() == other.hasEndpointAccessList()
                && Objects.equals(endpointAccessList(), other.endpointAccessList()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointAccessResponse")
                .add("EndpointAccessList", hasEndpointAccessList() ? endpointAccessList() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointAccessList":
            return Optional.ofNullable(clazz.cast(endpointAccessList()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointAccessList", ENDPOINT_ACCESS_LIST_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointAccessResponse, T> g) {
        return obj -> g.apply((DescribeEndpointAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEndpointAccessResponse> {
        /**
         * <p>
         * The list of endpoints with access to the cluster.
         * </p>
         * 
         * @param endpointAccessList
         *        The list of endpoints with access to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAccessList(Collection<EndpointAccess> endpointAccessList);

        /**
         * <p>
         * The list of endpoints with access to the cluster.
         * </p>
         * 
         * @param endpointAccessList
         *        The list of endpoints with access to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAccessList(EndpointAccess... endpointAccessList);

        /**
         * <p>
         * The list of endpoints with access to the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.EndpointAccess.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.redshift.model.EndpointAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.EndpointAccess.Builder#build()} is called immediately
         * and its result is passed to {@link #endpointAccessList(List<EndpointAccess>)}.
         * 
         * @param endpointAccessList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.EndpointAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointAccessList(java.util.Collection<EndpointAccess>)
         */
        Builder endpointAccessList(Consumer<EndpointAccess.Builder>... endpointAccessList);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * the <code>MaxRecords</code> parameter.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If
         *        this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by the <code>MaxRecords</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<EndpointAccess> endpointAccessList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointAccessResponse model) {
            super(model);
            endpointAccessList(model.endpointAccessList);
            marker(model.marker);
        }

        public final List<EndpointAccess.Builder> getEndpointAccessList() {
            List<EndpointAccess.Builder> result = EndpointAccessesCopier.copyToBuilder(this.endpointAccessList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointAccessList(Collection<EndpointAccess.BuilderImpl> endpointAccessList) {
            this.endpointAccessList = EndpointAccessesCopier.copyFromBuilder(endpointAccessList);
        }

        @Override
        public final Builder endpointAccessList(Collection<EndpointAccess> endpointAccessList) {
            this.endpointAccessList = EndpointAccessesCopier.copy(endpointAccessList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointAccessList(EndpointAccess... endpointAccessList) {
            endpointAccessList(Arrays.asList(endpointAccessList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointAccessList(Consumer<EndpointAccess.Builder>... endpointAccessList) {
            endpointAccessList(Stream.of(endpointAccessList).map(c -> EndpointAccess.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeEndpointAccessResponse build() {
            return new DescribeEndpointAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
