/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClusterCredentialsWithIamResponse extends RedshiftResponse implements
        ToCopyableBuilder<GetClusterCredentialsWithIamResponse.Builder, GetClusterCredentialsWithIamResponse> {
    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(GetClusterCredentialsWithIamResponse::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbPassword").getter(getter(GetClusterCredentialsWithIamResponse::dbPassword))
            .setter(setter(Builder::dbPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Expiration").getter(getter(GetClusterCredentialsWithIamResponse::expiration))
            .setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final SdkField<Instant> NEXT_REFRESH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NextRefreshTime").getter(getter(GetClusterCredentialsWithIamResponse::nextRefreshTime))
            .setter(setter(Builder::nextRefreshTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRefreshTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_USER_FIELD,
            DB_PASSWORD_FIELD, EXPIRATION_FIELD, NEXT_REFRESH_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbUser;

    private final String dbPassword;

    private final Instant expiration;

    private final Instant nextRefreshTime;

    private GetClusterCredentialsWithIamResponse(BuilderImpl builder) {
        super(builder);
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.expiration = builder.expiration;
        this.nextRefreshTime = builder.nextRefreshTime;
    }

    /**
     * <p>
     * A database user name that you provide when you connect to a database. The database user is mapped 1:1 to the
     * source IAM identity.
     * </p>
     * 
     * @return A database user name that you provide when you connect to a database. The database user is mapped 1:1 to
     *         the source IAM identity.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * A temporary password that you provide when you connect to a database.
     * </p>
     * 
     * @return A temporary password that you provide when you connect to a database.
     */
    public final String dbPassword() {
        return dbPassword;
    }

    /**
     * <p>
     * The time (UTC) when the temporary password expires. After this timestamp, a log in with the temporary password
     * fails.
     * </p>
     * 
     * @return The time (UTC) when the temporary password expires. After this timestamp, a log in with the temporary
     *         password fails.
     */
    public final Instant expiration() {
        return expiration;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final Instant nextRefreshTime() {
        return nextRefreshTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(nextRefreshTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsWithIamResponse)) {
            return false;
        }
        GetClusterCredentialsWithIamResponse other = (GetClusterCredentialsWithIamResponse) obj;
        return Objects.equals(dbUser(), other.dbUser()) && Objects.equals(dbPassword(), other.dbPassword())
                && Objects.equals(expiration(), other.expiration()) && Objects.equals(nextRefreshTime(), other.nextRefreshTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClusterCredentialsWithIamResponse").add("DbUser", dbUser())
                .add("DbPassword", dbPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Expiration", expiration()).add("NextRefreshTime", nextRefreshTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "DbPassword":
            return Optional.ofNullable(clazz.cast(dbPassword()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "NextRefreshTime":
            return Optional.ofNullable(clazz.cast(nextRefreshTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DbUser", DB_USER_FIELD);
        map.put("DbPassword", DB_PASSWORD_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        map.put("NextRefreshTime", NEXT_REFRESH_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClusterCredentialsWithIamResponse, T> g) {
        return obj -> g.apply((GetClusterCredentialsWithIamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetClusterCredentialsWithIamResponse> {
        /**
         * <p>
         * A database user name that you provide when you connect to a database. The database user is mapped 1:1 to the
         * source IAM identity.
         * </p>
         * 
         * @param dbUser
         *        A database user name that you provide when you connect to a database. The database user is mapped 1:1
         *        to the source IAM identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * A temporary password that you provide when you connect to a database.
         * </p>
         * 
         * @param dbPassword
         *        A temporary password that you provide when you connect to a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        /**
         * <p>
         * The time (UTC) when the temporary password expires. After this timestamp, a log in with the temporary
         * password fails.
         * </p>
         * 
         * @param expiration
         *        The time (UTC) when the temporary password expires. After this timestamp, a log in with the temporary
         *        password fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param nextRefreshTime
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRefreshTime(Instant nextRefreshTime);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String dbUser;

        private String dbPassword;

        private Instant expiration;

        private Instant nextRefreshTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsWithIamResponse model) {
            super(model);
            dbUser(model.dbUser);
            dbPassword(model.dbPassword);
            expiration(model.expiration);
            nextRefreshTime(model.nextRefreshTime);
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final Instant getNextRefreshTime() {
            return nextRefreshTime;
        }

        public final void setNextRefreshTime(Instant nextRefreshTime) {
            this.nextRefreshTime = nextRefreshTime;
        }

        @Override
        public final Builder nextRefreshTime(Instant nextRefreshTime) {
            this.nextRefreshTime = nextRefreshTime;
            return this;
        }

        @Override
        public GetClusterCredentialsWithIamResponse build() {
            return new GetClusterCredentialsWithIamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
