/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of an inbound integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundIntegration implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundIntegration.Builder, InboundIntegration> {
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationArn").getter(getter(InboundIntegration::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(InboundIntegration::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(InboundIntegration::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InboundIntegration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<IntegrationError>> ERRORS_FIELD = SdkField
            .<List<IntegrationError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(InboundIntegration::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IntegrationError")
                            .memberFieldInfo(
                                    SdkField.<IntegrationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegrationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IntegrationError").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(InboundIntegration::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ARN_FIELD,
            SOURCE_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, ERRORS_FIELD, CREATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String integrationArn;

    private final String sourceArn;

    private final String targetArn;

    private final String status;

    private final List<IntegrationError> errors;

    private final Instant createTime;

    private InboundIntegration(BuilderImpl builder) {
        this.integrationArn = builder.integrationArn;
        this.sourceArn = builder.sourceArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.errors = builder.errors;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an inbound integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an inbound integration.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source of an inbound integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source of an inbound integration.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target of an inbound integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target of an inbound integration.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The status of an inbound integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZeroETLIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an inbound integration.
     * @see ZeroETLIntegrationStatus
     */
    public final ZeroETLIntegrationStatus status() {
        return ZeroETLIntegrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of an inbound integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZeroETLIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an inbound integration.
     * @see ZeroETLIntegrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outstanding errors of an inbound integration. Each item is an "IntegrationError". This is null if there is no
     * error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return The outstanding errors of an inbound integration. Each item is an "IntegrationError". This is null if
     *         there is no error.
     */
    public final List<IntegrationError> errors() {
        return errors;
    }

    /**
     * <p>
     * The creation time of an inbound integration.
     * </p>
     * 
     * @return The creation time of an inbound integration.
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundIntegration)) {
            return false;
        }
        InboundIntegration other = (InboundIntegration) obj;
        return Objects.equals(integrationArn(), other.integrationArn()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(targetArn(), other.targetArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundIntegration").add("IntegrationArn", integrationArn()).add("SourceArn", sourceArn())
                .add("TargetArn", targetArn()).add("Status", statusAsString()).add("Errors", hasErrors() ? errors() : null)
                .add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IntegrationArn", INTEGRATION_ARN_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("TargetArn", TARGET_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundIntegration, T> g) {
        return obj -> g.apply((InboundIntegration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundIntegration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an inbound integration.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of an inbound integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source of an inbound integration.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the source of an inbound integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target of an inbound integration.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) of the target of an inbound integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The status of an inbound integration.
         * </p>
         * 
         * @param status
         *        The status of an inbound integration.
         * @see ZeroETLIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZeroETLIntegrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of an inbound integration.
         * </p>
         * 
         * @param status
         *        The status of an inbound integration.
         * @see ZeroETLIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZeroETLIntegrationStatus
         */
        Builder status(ZeroETLIntegrationStatus status);

        /**
         * <p>
         * The outstanding errors of an inbound integration. Each item is an "IntegrationError". This is null if there
         * is no error.
         * </p>
         * 
         * @param errors
         *        The outstanding errors of an inbound integration. Each item is an "IntegrationError". This is null if
         *        there is no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<IntegrationError> errors);

        /**
         * <p>
         * The outstanding errors of an inbound integration. Each item is an "IntegrationError". This is null if there
         * is no error.
         * </p>
         * 
         * @param errors
         *        The outstanding errors of an inbound integration. Each item is an "IntegrationError". This is null if
         *        there is no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(IntegrationError... errors);

        /**
         * <p>
         * The outstanding errors of an inbound integration. Each item is an "IntegrationError". This is null if there
         * is no error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.IntegrationError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshift.model.IntegrationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.IntegrationError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<IntegrationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.IntegrationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<IntegrationError>)
         */
        Builder errors(Consumer<IntegrationError.Builder>... errors);

        /**
         * <p>
         * The creation time of an inbound integration.
         * </p>
         * 
         * @param createTime
         *        The creation time of an inbound integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl implements Builder {
        private String integrationArn;

        private String sourceArn;

        private String targetArn;

        private String status;

        private List<IntegrationError> errors = DefaultSdkAutoConstructList.getInstance();

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InboundIntegration model) {
            integrationArn(model.integrationArn);
            sourceArn(model.sourceArn);
            targetArn(model.targetArn);
            status(model.status);
            errors(model.errors);
            createTime(model.createTime);
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ZeroETLIntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<IntegrationError.Builder> getErrors() {
            List<IntegrationError.Builder> result = IntegrationErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<IntegrationError.BuilderImpl> errors) {
            this.errors = IntegrationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<IntegrationError> errors) {
            this.errors = IntegrationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(IntegrationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<IntegrationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> IntegrationError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public InboundIntegration build() {
            return new InboundIntegration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
