/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClusterIamRolesRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyClusterIamRolesRequest.Builder, ModifyClusterIamRolesRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyClusterIamRolesRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<List<String>> ADD_IAM_ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddIamRoles")
            .getter(getter(ModifyClusterIamRolesRequest::addIamRoles))
            .setter(setter(Builder::addIamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddIamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IamRoleArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IamRoleArn").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_IAM_ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveIamRoles")
            .getter(getter(ModifyClusterIamRolesRequest::removeIamRoles))
            .setter(setter(Builder::removeIamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveIamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IamRoleArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IamRoleArn").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultIamRoleArn").getter(getter(ModifyClusterIamRolesRequest::defaultIamRoleArn))
            .setter(setter(Builder::defaultIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultIamRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            ADD_IAM_ROLES_FIELD, REMOVE_IAM_ROLES_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final List<String> addIamRoles;

    private final List<String> removeIamRoles;

    private final String defaultIamRoleArn;

    private ModifyClusterIamRolesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.addIamRoles = builder.addIamRoles;
        this.removeIamRoles = builder.removeIamRoles;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
    }

    /**
     * <p>
     * The unique identifier of the cluster for which you want to associate or disassociate IAM roles.
     * </p>
     * 
     * @return The unique identifier of the cluster for which you want to associate or disassociate IAM roles.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddIamRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddIamRoles() {
        return addIamRoles != null && !(addIamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN)
     * format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddIamRoles} method.
     * </p>
     * 
     * @return Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name
     *         (ARN) format.
     */
    public final List<String> addIamRoles() {
        return addIamRoles;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveIamRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveIamRoles() {
        return removeIamRoles != null && !(removeIamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Zero or more IAM roles in ARN format to disassociate from the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveIamRoles} method.
     * </p>
     * 
     * @return Zero or more IAM roles in ARN format to disassociate from the cluster.
     */
    public final List<String> removeIamRoles() {
        return removeIamRoles;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last
     * modified.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster
     *         was last modified.
     */
    public final String defaultIamRoleArn() {
        return defaultIamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddIamRoles() ? addIamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveIamRoles() ? removeIamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultIamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterIamRolesRequest)) {
            return false;
        }
        ModifyClusterIamRolesRequest other = (ModifyClusterIamRolesRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && hasAddIamRoles() == other.hasAddIamRoles()
                && Objects.equals(addIamRoles(), other.addIamRoles()) && hasRemoveIamRoles() == other.hasRemoveIamRoles()
                && Objects.equals(removeIamRoles(), other.removeIamRoles())
                && Objects.equals(defaultIamRoleArn(), other.defaultIamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClusterIamRolesRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("AddIamRoles", hasAddIamRoles() ? addIamRoles() : null)
                .add("RemoveIamRoles", hasRemoveIamRoles() ? removeIamRoles() : null)
                .add("DefaultIamRoleArn", defaultIamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "AddIamRoles":
            return Optional.ofNullable(clazz.cast(addIamRoles()));
        case "RemoveIamRoles":
            return Optional.ofNullable(clazz.cast(removeIamRoles()));
        case "DefaultIamRoleArn":
            return Optional.ofNullable(clazz.cast(defaultIamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("AddIamRoles", ADD_IAM_ROLES_FIELD);
        map.put("RemoveIamRoles", REMOVE_IAM_ROLES_FIELD);
        map.put("DefaultIamRoleArn", DEFAULT_IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterIamRolesRequest, T> g) {
        return obj -> g.apply((ModifyClusterIamRolesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClusterIamRolesRequest> {
        /**
         * <p>
         * The unique identifier of the cluster for which you want to associate or disassociate IAM roles.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the cluster for which you want to associate or disassociate IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN)
         * format.
         * </p>
         * 
         * @param addIamRoles
         *        Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name
         *        (ARN) format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addIamRoles(Collection<String> addIamRoles);

        /**
         * <p>
         * Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN)
         * format.
         * </p>
         * 
         * @param addIamRoles
         *        Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name
         *        (ARN) format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addIamRoles(String... addIamRoles);

        /**
         * <p>
         * Zero or more IAM roles in ARN format to disassociate from the cluster.
         * </p>
         * 
         * @param removeIamRoles
         *        Zero or more IAM roles in ARN format to disassociate from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeIamRoles(Collection<String> removeIamRoles);

        /**
         * <p>
         * Zero or more IAM roles in ARN format to disassociate from the cluster.
         * </p>
         * 
         * @param removeIamRoles
         *        Zero or more IAM roles in ARN format to disassociate from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeIamRoles(String... removeIamRoles);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was
         * last modified.
         * </p>
         * 
         * @param defaultIamRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the
         *        cluster was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultIamRoleArn(String defaultIamRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private List<String> addIamRoles = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeIamRoles = DefaultSdkAutoConstructList.getInstance();

        private String defaultIamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterIamRolesRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            addIamRoles(model.addIamRoles);
            removeIamRoles(model.removeIamRoles);
            defaultIamRoleArn(model.defaultIamRoleArn);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Collection<String> getAddIamRoles() {
            if (addIamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return addIamRoles;
        }

        public final void setAddIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
        }

        @Override
        public final Builder addIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addIamRoles(String... addIamRoles) {
            addIamRoles(Arrays.asList(addIamRoles));
            return this;
        }

        public final Collection<String> getRemoveIamRoles() {
            if (removeIamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return removeIamRoles;
        }

        public final void setRemoveIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
        }

        @Override
        public final Builder removeIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIamRoles(String... removeIamRoles) {
            removeIamRoles(Arrays.asList(removeIamRoles));
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterIamRolesRequest build() {
            return new ModifyClusterIamRolesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
