/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClusterMaintenanceRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyClusterMaintenanceRequest.Builder, ModifyClusterMaintenanceRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyClusterMaintenanceRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Boolean> DEFER_MAINTENANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeferMaintenance").getter(getter(ModifyClusterMaintenanceRequest::deferMaintenance))
            .setter(setter(Builder::deferMaintenance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenance").build()).build();

    private static final SdkField<String> DEFER_MAINTENANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeferMaintenanceIdentifier")
            .getter(getter(ModifyClusterMaintenanceRequest::deferMaintenanceIdentifier))
            .setter(setter(Builder::deferMaintenanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceIdentifier").build())
            .build();

    private static final SdkField<Instant> DEFER_MAINTENANCE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("DeferMaintenanceStartTime")
            .getter(getter(ModifyClusterMaintenanceRequest::deferMaintenanceStartTime))
            .setter(setter(Builder::deferMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceStartTime").build())
            .build();

    private static final SdkField<Instant> DEFER_MAINTENANCE_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeferMaintenanceEndTime").getter(getter(ModifyClusterMaintenanceRequest::deferMaintenanceEndTime))
            .setter(setter(Builder::deferMaintenanceEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceEndTime").build())
            .build();

    private static final SdkField<Integer> DEFER_MAINTENANCE_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeferMaintenanceDuration").getter(getter(ModifyClusterMaintenanceRequest::deferMaintenanceDuration))
            .setter(setter(Builder::deferMaintenanceDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceDuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            DEFER_MAINTENANCE_FIELD, DEFER_MAINTENANCE_IDENTIFIER_FIELD, DEFER_MAINTENANCE_START_TIME_FIELD,
            DEFER_MAINTENANCE_END_TIME_FIELD, DEFER_MAINTENANCE_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final Boolean deferMaintenance;

    private final String deferMaintenanceIdentifier;

    private final Instant deferMaintenanceStartTime;

    private final Instant deferMaintenanceEndTime;

    private final Integer deferMaintenanceDuration;

    private ModifyClusterMaintenanceRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.deferMaintenance = builder.deferMaintenance;
        this.deferMaintenanceIdentifier = builder.deferMaintenanceIdentifier;
        this.deferMaintenanceStartTime = builder.deferMaintenanceStartTime;
        this.deferMaintenanceEndTime = builder.deferMaintenanceEndTime;
        this.deferMaintenanceDuration = builder.deferMaintenanceDuration;
    }

    /**
     * <p>
     * A unique identifier for the cluster.
     * </p>
     * 
     * @return A unique identifier for the cluster.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * A boolean indicating whether to enable the deferred maintenance window.
     * </p>
     * 
     * @return A boolean indicating whether to enable the deferred maintenance window.
     */
    public final Boolean deferMaintenance() {
        return deferMaintenance;
    }

    /**
     * <p>
     * A unique identifier for the deferred maintenance window.
     * </p>
     * 
     * @return A unique identifier for the deferred maintenance window.
     */
    public final String deferMaintenanceIdentifier() {
        return deferMaintenanceIdentifier;
    }

    /**
     * <p>
     * A timestamp indicating the start time for the deferred maintenance window.
     * </p>
     * 
     * @return A timestamp indicating the start time for the deferred maintenance window.
     */
    public final Instant deferMaintenanceStartTime() {
        return deferMaintenanceStartTime;
    }

    /**
     * <p>
     * A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't
     * specify a duration.
     * </p>
     * 
     * @return A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you
     *         can't specify a duration.
     */
    public final Instant deferMaintenanceEndTime() {
        return deferMaintenanceEndTime;
    }

    /**
     * <p>
     * An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't
     * specify an end time. The duration must be 45 days or less.
     * </p>
     * 
     * @return An integer indicating the duration of the maintenance window in days. If you specify a duration, you
     *         can't specify an end time. The duration must be 45 days or less.
     */
    public final Integer deferMaintenanceDuration() {
        return deferMaintenanceDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenance());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterMaintenanceRequest)) {
            return false;
        }
        ModifyClusterMaintenanceRequest other = (ModifyClusterMaintenanceRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(deferMaintenance(), other.deferMaintenance())
                && Objects.equals(deferMaintenanceIdentifier(), other.deferMaintenanceIdentifier())
                && Objects.equals(deferMaintenanceStartTime(), other.deferMaintenanceStartTime())
                && Objects.equals(deferMaintenanceEndTime(), other.deferMaintenanceEndTime())
                && Objects.equals(deferMaintenanceDuration(), other.deferMaintenanceDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClusterMaintenanceRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("DeferMaintenance", deferMaintenance()).add("DeferMaintenanceIdentifier", deferMaintenanceIdentifier())
                .add("DeferMaintenanceStartTime", deferMaintenanceStartTime())
                .add("DeferMaintenanceEndTime", deferMaintenanceEndTime())
                .add("DeferMaintenanceDuration", deferMaintenanceDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "DeferMaintenance":
            return Optional.ofNullable(clazz.cast(deferMaintenance()));
        case "DeferMaintenanceIdentifier":
            return Optional.ofNullable(clazz.cast(deferMaintenanceIdentifier()));
        case "DeferMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(deferMaintenanceStartTime()));
        case "DeferMaintenanceEndTime":
            return Optional.ofNullable(clazz.cast(deferMaintenanceEndTime()));
        case "DeferMaintenanceDuration":
            return Optional.ofNullable(clazz.cast(deferMaintenanceDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("DeferMaintenance", DEFER_MAINTENANCE_FIELD);
        map.put("DeferMaintenanceIdentifier", DEFER_MAINTENANCE_IDENTIFIER_FIELD);
        map.put("DeferMaintenanceStartTime", DEFER_MAINTENANCE_START_TIME_FIELD);
        map.put("DeferMaintenanceEndTime", DEFER_MAINTENANCE_END_TIME_FIELD);
        map.put("DeferMaintenanceDuration", DEFER_MAINTENANCE_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterMaintenanceRequest, T> g) {
        return obj -> g.apply((ModifyClusterMaintenanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClusterMaintenanceRequest> {
        /**
         * <p>
         * A unique identifier for the cluster.
         * </p>
         * 
         * @param clusterIdentifier
         *        A unique identifier for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * A boolean indicating whether to enable the deferred maintenance window.
         * </p>
         * 
         * @param deferMaintenance
         *        A boolean indicating whether to enable the deferred maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenance(Boolean deferMaintenance);

        /**
         * <p>
         * A unique identifier for the deferred maintenance window.
         * </p>
         * 
         * @param deferMaintenanceIdentifier
         *        A unique identifier for the deferred maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier);

        /**
         * <p>
         * A timestamp indicating the start time for the deferred maintenance window.
         * </p>
         * 
         * @param deferMaintenanceStartTime
         *        A timestamp indicating the start time for the deferred maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceStartTime(Instant deferMaintenanceStartTime);

        /**
         * <p>
         * A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't
         * specify a duration.
         * </p>
         * 
         * @param deferMaintenanceEndTime
         *        A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you
         *        can't specify a duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceEndTime(Instant deferMaintenanceEndTime);

        /**
         * <p>
         * An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't
         * specify an end time. The duration must be 45 days or less.
         * </p>
         * 
         * @param deferMaintenanceDuration
         *        An integer indicating the duration of the maintenance window in days. If you specify a duration, you
         *        can't specify an end time. The duration must be 45 days or less.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceDuration(Integer deferMaintenanceDuration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private Boolean deferMaintenance;

        private String deferMaintenanceIdentifier;

        private Instant deferMaintenanceStartTime;

        private Instant deferMaintenanceEndTime;

        private Integer deferMaintenanceDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterMaintenanceRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            deferMaintenance(model.deferMaintenance);
            deferMaintenanceIdentifier(model.deferMaintenanceIdentifier);
            deferMaintenanceStartTime(model.deferMaintenanceStartTime);
            deferMaintenanceEndTime(model.deferMaintenanceEndTime);
            deferMaintenanceDuration(model.deferMaintenanceDuration);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Boolean getDeferMaintenance() {
            return deferMaintenance;
        }

        public final void setDeferMaintenance(Boolean deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
        }

        @Override
        public final Builder deferMaintenance(Boolean deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
            return this;
        }

        public final String getDeferMaintenanceIdentifier() {
            return deferMaintenanceIdentifier;
        }

        public final void setDeferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
        }

        @Override
        public final Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
            return this;
        }

        public final Instant getDeferMaintenanceStartTime() {
            return deferMaintenanceStartTime;
        }

        public final void setDeferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
        }

        @Override
        public final Builder deferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
            return this;
        }

        public final Instant getDeferMaintenanceEndTime() {
            return deferMaintenanceEndTime;
        }

        public final void setDeferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
        }

        @Override
        public final Builder deferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
            return this;
        }

        public final Integer getDeferMaintenanceDuration() {
            return deferMaintenanceDuration;
        }

        public final void setDeferMaintenanceDuration(Integer deferMaintenanceDuration) {
            this.deferMaintenanceDuration = deferMaintenanceDuration;
        }

        @Override
        public final Builder deferMaintenanceDuration(Integer deferMaintenanceDuration) {
            this.deferMaintenanceDuration = deferMaintenanceDuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterMaintenanceRequest build() {
            return new ModifyClusterMaintenanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
