/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySnapshotCopyRetentionPeriodRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifySnapshotCopyRetentionPeriodRequest.Builder, ModifySnapshotCopyRetentionPeriodRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifySnapshotCopyRetentionPeriodRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriod").getter(getter(ModifySnapshotCopyRetentionPeriodRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<Boolean> MANUAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Manual").getter(getter(ModifySnapshotCopyRetentionPeriodRequest::manual))
            .setter(setter(Builder::manual))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manual").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            RETENTION_PERIOD_FIELD, MANUAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final Integer retentionPeriod;

    private final Boolean manual;

    private ModifySnapshotCopyRetentionPeriodRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.retentionPeriod = builder.retentionPeriod;
        this.manual = builder.manual;
    }

    /**
     * <p>
     * The unique identifier of the cluster for which you want to change the retention period for either automated or
     * manual snapshots that are copied to a destination Amazon Web Services Region.
     * </p>
     * <p>
     * Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.
     * </p>
     * 
     * @return The unique identifier of the cluster for which you want to change the retention period for either
     *         automated or manual snapshots that are copied to a destination Amazon Web Services Region.</p>
     *         <p>
     *         Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The number of days to retain automated snapshots in the destination Amazon Web Services Region after they are
     * copied from the source Amazon Web Services Region.
     * </p>
     * <p>
     * By default, this only changes the retention period of copied automated snapshots.
     * </p>
     * <p>
     * If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web Services
     * Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination Amazon Web
     * Services Region and that fall outside of the new retention period.
     * </p>
     * <p>
     * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
     * </p>
     * <p>
     * If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention
     * period.
     * </p>
     * <p>
     * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
     * </p>
     * <p>
     * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
     * </p>
     * 
     * @return The number of days to retain automated snapshots in the destination Amazon Web Services Region after they
     *         are copied from the source Amazon Web Services Region.</p>
     *         <p>
     *         By default, this only changes the retention period of copied automated snapshots.
     *         </p>
     *         <p>
     *         If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web
     *         Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the
     *         destination Amazon Web Services Region and that fall outside of the new retention period.
     *         </p>
     *         <p>
     *         Constraints: Must be at least 1 and no more than 35 for automated snapshots.
     *         </p>
     *         <p>
     *         If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new
     *         retention period.
     *         </p>
     *         <p>
     *         If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
     *         </p>
     *         <p>
     *         Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated
     * snapshots.
     * </p>
     * 
     * @return Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of
     *         automated snapshots.
     */
    public final Boolean manual() {
        return manual;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manual());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotCopyRetentionPeriodRequest)) {
            return false;
        }
        ModifySnapshotCopyRetentionPeriodRequest other = (ModifySnapshotCopyRetentionPeriodRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(retentionPeriod(), other.retentionPeriod()) && Objects.equals(manual(), other.manual());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySnapshotCopyRetentionPeriodRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("RetentionPeriod", retentionPeriod()).add("Manual", manual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "Manual":
            return Optional.ofNullable(clazz.cast(manual()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("Manual", MANUAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotCopyRetentionPeriodRequest, T> g) {
        return obj -> g.apply((ModifySnapshotCopyRetentionPeriodRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifySnapshotCopyRetentionPeriodRequest> {
        /**
         * <p>
         * The unique identifier of the cluster for which you want to change the retention period for either automated
         * or manual snapshots that are copied to a destination Amazon Web Services Region.
         * </p>
         * <p>
         * Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the cluster for which you want to change the retention period for either
         *        automated or manual snapshots that are copied to a destination Amazon Web Services Region.</p>
         *        <p>
         *        Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The number of days to retain automated snapshots in the destination Amazon Web Services Region after they are
         * copied from the source Amazon Web Services Region.
         * </p>
         * <p>
         * By default, this only changes the retention period of copied automated snapshots.
         * </p>
         * <p>
         * If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web
         * Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination
         * Amazon Web Services Region and that fall outside of the new retention period.
         * </p>
         * <p>
         * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
         * </p>
         * <p>
         * If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention
         * period.
         * </p>
         * <p>
         * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
         * </p>
         * <p>
         * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
         * </p>
         * 
         * @param retentionPeriod
         *        The number of days to retain automated snapshots in the destination Amazon Web Services Region after
         *        they are copied from the source Amazon Web Services Region.</p>
         *        <p>
         *        By default, this only changes the retention period of copied automated snapshots.
         *        </p>
         *        <p>
         *        If you decrease the retention period for automated snapshots that are copied to a destination Amazon
         *        Web Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the
         *        destination Amazon Web Services Region and that fall outside of the new retention period.
         *        </p>
         *        <p>
         *        Constraints: Must be at least 1 and no more than 35 for automated snapshots.
         *        </p>
         *        <p>
         *        If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new
         *        retention period.
         *        </p>
         *        <p>
         *        If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
         *        </p>
         *        <p>
         *        Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual
         *        snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of
         * automated snapshots.
         * </p>
         * 
         * @param manual
         *        Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of
         *        automated snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manual(Boolean manual);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private Integer retentionPeriod;

        private Boolean manual;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotCopyRetentionPeriodRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            retentionPeriod(model.retentionPeriod);
            manual(model.manual);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Boolean getManual() {
            return manual;
        }

        public final void setManual(Boolean manual) {
            this.manual = manual;
        }

        @Override
        public final Builder manual(Boolean manual) {
            this.manual = manual;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotCopyRetentionPeriodRequest build() {
            return new ModifySnapshotCopyRetentionPeriodRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
