/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object to store union of values for a provisioned cluster or serverless namespace’s identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamespaceIdentifierUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<NamespaceIdentifierUnion.Builder, NamespaceIdentifierUnion> {
    private static final SdkField<ServerlessIdentifier> SERVERLESS_IDENTIFIER_FIELD = SdkField
            .<ServerlessIdentifier> builder(MarshallingType.SDK_POJO).memberName("ServerlessIdentifier")
            .getter(getter(NamespaceIdentifierUnion::serverlessIdentifier)).setter(setter(Builder::serverlessIdentifier))
            .constructor(ServerlessIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessIdentifier").build())
            .build();

    private static final SdkField<ProvisionedIdentifier> PROVISIONED_IDENTIFIER_FIELD = SdkField
            .<ProvisionedIdentifier> builder(MarshallingType.SDK_POJO).memberName("ProvisionedIdentifier")
            .getter(getter(NamespaceIdentifierUnion::provisionedIdentifier)).setter(setter(Builder::provisionedIdentifier))
            .constructor(ProvisionedIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_IDENTIFIER_FIELD,
            PROVISIONED_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServerlessIdentifier serverlessIdentifier;

    private final ProvisionedIdentifier provisionedIdentifier;

    private final Type type;

    private NamespaceIdentifierUnion(BuilderImpl builder) {
        this.serverlessIdentifier = builder.serverlessIdentifier;
        this.provisionedIdentifier = builder.provisionedIdentifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier for a serverless namespace.
     * </p>
     * 
     * @return The identifier for a serverless namespace.
     */
    public final ServerlessIdentifier serverlessIdentifier() {
        return serverlessIdentifier;
    }

    /**
     * <p>
     * The identifier for a provisioned cluster.
     * </p>
     * 
     * @return The identifier for a provisioned cluster.
     */
    public final ProvisionedIdentifier provisionedIdentifier() {
        return provisionedIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverlessIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceIdentifierUnion)) {
            return false;
        }
        NamespaceIdentifierUnion other = (NamespaceIdentifierUnion) obj;
        return Objects.equals(serverlessIdentifier(), other.serverlessIdentifier())
                && Objects.equals(provisionedIdentifier(), other.provisionedIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NamespaceIdentifierUnion").add("ServerlessIdentifier", serverlessIdentifier())
                .add("ProvisionedIdentifier", provisionedIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessIdentifier":
            return Optional.ofNullable(clazz.cast(serverlessIdentifier()));
        case "ProvisionedIdentifier":
            return Optional.ofNullable(clazz.cast(provisionedIdentifier()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #serverlessIdentifier()} initialized to the given value.
     *
     * <p>
     * The identifier for a serverless namespace.
     * </p>
     * 
     * @param serverlessIdentifier
     *        The identifier for a serverless namespace.
     */
    public static NamespaceIdentifierUnion fromServerlessIdentifier(ServerlessIdentifier serverlessIdentifier) {
        return builder().serverlessIdentifier(serverlessIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #serverlessIdentifier()} initialized to the given value.
     *
     * <p>
     * The identifier for a serverless namespace.
     * </p>
     * 
     * @param serverlessIdentifier
     *        The identifier for a serverless namespace.
     */
    public static NamespaceIdentifierUnion fromServerlessIdentifier(Consumer<ServerlessIdentifier.Builder> serverlessIdentifier) {
        ServerlessIdentifier.Builder builder = ServerlessIdentifier.builder();
        serverlessIdentifier.accept(builder);
        return fromServerlessIdentifier(builder.build());
    }

    /**
     * Create an instance of this class with {@link #provisionedIdentifier()} initialized to the given value.
     *
     * <p>
     * The identifier for a provisioned cluster.
     * </p>
     * 
     * @param provisionedIdentifier
     *        The identifier for a provisioned cluster.
     */
    public static NamespaceIdentifierUnion fromProvisionedIdentifier(ProvisionedIdentifier provisionedIdentifier) {
        return builder().provisionedIdentifier(provisionedIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #provisionedIdentifier()} initialized to the given value.
     *
     * <p>
     * The identifier for a provisioned cluster.
     * </p>
     * 
     * @param provisionedIdentifier
     *        The identifier for a provisioned cluster.
     */
    public static NamespaceIdentifierUnion fromProvisionedIdentifier(Consumer<ProvisionedIdentifier.Builder> provisionedIdentifier) {
        ProvisionedIdentifier.Builder builder = ProvisionedIdentifier.builder();
        provisionedIdentifier.accept(builder);
        return fromProvisionedIdentifier(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerlessIdentifier", SERVERLESS_IDENTIFIER_FIELD);
        map.put("ProvisionedIdentifier", PROVISIONED_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NamespaceIdentifierUnion, T> g) {
        return obj -> g.apply((NamespaceIdentifierUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamespaceIdentifierUnion> {
        /**
         * <p>
         * The identifier for a serverless namespace.
         * </p>
         * 
         * @param serverlessIdentifier
         *        The identifier for a serverless namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessIdentifier(ServerlessIdentifier serverlessIdentifier);

        /**
         * <p>
         * The identifier for a serverless namespace.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerlessIdentifier.Builder} avoiding
         * the need to create one manually via {@link ServerlessIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #serverlessIdentifier(ServerlessIdentifier)}.
         * 
         * @param serverlessIdentifier
         *        a consumer that will call methods on {@link ServerlessIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessIdentifier(ServerlessIdentifier)
         */
        default Builder serverlessIdentifier(Consumer<ServerlessIdentifier.Builder> serverlessIdentifier) {
            return serverlessIdentifier(ServerlessIdentifier.builder().applyMutation(serverlessIdentifier).build());
        }

        /**
         * <p>
         * The identifier for a provisioned cluster.
         * </p>
         * 
         * @param provisionedIdentifier
         *        The identifier for a provisioned cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedIdentifier(ProvisionedIdentifier provisionedIdentifier);

        /**
         * <p>
         * The identifier for a provisioned cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedIdentifier.Builder} avoiding
         * the need to create one manually via {@link ProvisionedIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedIdentifier(ProvisionedIdentifier)}.
         * 
         * @param provisionedIdentifier
         *        a consumer that will call methods on {@link ProvisionedIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedIdentifier(ProvisionedIdentifier)
         */
        default Builder provisionedIdentifier(Consumer<ProvisionedIdentifier.Builder> provisionedIdentifier) {
            return provisionedIdentifier(ProvisionedIdentifier.builder().applyMutation(provisionedIdentifier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServerlessIdentifier serverlessIdentifier;

        private ProvisionedIdentifier provisionedIdentifier;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceIdentifierUnion model) {
            serverlessIdentifier(model.serverlessIdentifier);
            provisionedIdentifier(model.provisionedIdentifier);
        }

        public final ServerlessIdentifier.Builder getServerlessIdentifier() {
            return serverlessIdentifier != null ? serverlessIdentifier.toBuilder() : null;
        }

        public final void setServerlessIdentifier(ServerlessIdentifier.BuilderImpl serverlessIdentifier) {
            Object oldValue = this.serverlessIdentifier;
            this.serverlessIdentifier = serverlessIdentifier != null ? serverlessIdentifier.build() : null;
            handleUnionValueChange(Type.SERVERLESS_IDENTIFIER, oldValue, this.serverlessIdentifier);
        }

        @Override
        public final Builder serverlessIdentifier(ServerlessIdentifier serverlessIdentifier) {
            Object oldValue = this.serverlessIdentifier;
            this.serverlessIdentifier = serverlessIdentifier;
            handleUnionValueChange(Type.SERVERLESS_IDENTIFIER, oldValue, this.serverlessIdentifier);
            return this;
        }

        public final ProvisionedIdentifier.Builder getProvisionedIdentifier() {
            return provisionedIdentifier != null ? provisionedIdentifier.toBuilder() : null;
        }

        public final void setProvisionedIdentifier(ProvisionedIdentifier.BuilderImpl provisionedIdentifier) {
            Object oldValue = this.provisionedIdentifier;
            this.provisionedIdentifier = provisionedIdentifier != null ? provisionedIdentifier.build() : null;
            handleUnionValueChange(Type.PROVISIONED_IDENTIFIER, oldValue, this.provisionedIdentifier);
        }

        @Override
        public final Builder provisionedIdentifier(ProvisionedIdentifier provisionedIdentifier) {
            Object oldValue = this.provisionedIdentifier;
            this.provisionedIdentifier = provisionedIdentifier;
            handleUnionValueChange(Type.PROVISIONED_IDENTIFIER, oldValue, this.provisionedIdentifier);
            return this;
        }

        @Override
        public NamespaceIdentifierUnion build() {
            return new NamespaceIdentifierUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see NamespaceIdentifierUnion#type()
     */
    public enum Type {
        SERVERLESS_IDENTIFIER,

        PROVISIONED_IDENTIFIER,

        UNKNOWN_TO_SDK_VERSION
    }
}
