/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for a reserved-node exchange. Examples include the node type for a reserved node, the price for a node, the
 * node's state, and other details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedNodeConfigurationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedNodeConfigurationOption.Builder, ReservedNodeConfigurationOption> {
    private static final SdkField<ReservedNode> SOURCE_RESERVED_NODE_FIELD = SdkField
            .<ReservedNode> builder(MarshallingType.SDK_POJO).memberName("SourceReservedNode")
            .getter(getter(ReservedNodeConfigurationOption::sourceReservedNode)).setter(setter(Builder::sourceReservedNode))
            .constructor(ReservedNode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNode").build())
            .build();

    private static final SdkField<Integer> TARGET_RESERVED_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetReservedNodeCount").getter(getter(ReservedNodeConfigurationOption::targetReservedNodeCount))
            .setter(setter(Builder::targetReservedNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeCount").build())
            .build();

    private static final SdkField<ReservedNodeOffering> TARGET_RESERVED_NODE_OFFERING_FIELD = SdkField
            .<ReservedNodeOffering> builder(MarshallingType.SDK_POJO)
            .memberName("TargetReservedNodeOffering")
            .getter(getter(ReservedNodeConfigurationOption::targetReservedNodeOffering))
            .setter(setter(Builder::targetReservedNodeOffering))
            .constructor(ReservedNodeOffering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOffering").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_RESERVED_NODE_FIELD,
            TARGET_RESERVED_NODE_COUNT_FIELD, TARGET_RESERVED_NODE_OFFERING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReservedNode sourceReservedNode;

    private final Integer targetReservedNodeCount;

    private final ReservedNodeOffering targetReservedNodeOffering;

    private ReservedNodeConfigurationOption(BuilderImpl builder) {
        this.sourceReservedNode = builder.sourceReservedNode;
        this.targetReservedNodeCount = builder.targetReservedNodeCount;
        this.targetReservedNodeOffering = builder.targetReservedNodeOffering;
    }

    /**
     * Returns the value of the SourceReservedNode property for this object.
     * 
     * @return The value of the SourceReservedNode property for this object.
     */
    public final ReservedNode sourceReservedNode() {
        return sourceReservedNode;
    }

    /**
     * <p>
     * The target reserved-node count.
     * </p>
     * 
     * @return The target reserved-node count.
     */
    public final Integer targetReservedNodeCount() {
        return targetReservedNodeCount;
    }

    /**
     * Returns the value of the TargetReservedNodeOffering property for this object.
     * 
     * @return The value of the TargetReservedNodeOffering property for this object.
     */
    public final ReservedNodeOffering targetReservedNodeOffering() {
        return targetReservedNodeOffering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceReservedNode());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeOffering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNodeConfigurationOption)) {
            return false;
        }
        ReservedNodeConfigurationOption other = (ReservedNodeConfigurationOption) obj;
        return Objects.equals(sourceReservedNode(), other.sourceReservedNode())
                && Objects.equals(targetReservedNodeCount(), other.targetReservedNodeCount())
                && Objects.equals(targetReservedNodeOffering(), other.targetReservedNodeOffering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedNodeConfigurationOption").add("SourceReservedNode", sourceReservedNode())
                .add("TargetReservedNodeCount", targetReservedNodeCount())
                .add("TargetReservedNodeOffering", targetReservedNodeOffering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceReservedNode":
            return Optional.ofNullable(clazz.cast(sourceReservedNode()));
        case "TargetReservedNodeCount":
            return Optional.ofNullable(clazz.cast(targetReservedNodeCount()));
        case "TargetReservedNodeOffering":
            return Optional.ofNullable(clazz.cast(targetReservedNodeOffering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceReservedNode", SOURCE_RESERVED_NODE_FIELD);
        map.put("TargetReservedNodeCount", TARGET_RESERVED_NODE_COUNT_FIELD);
        map.put("TargetReservedNodeOffering", TARGET_RESERVED_NODE_OFFERING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedNodeConfigurationOption, T> g) {
        return obj -> g.apply((ReservedNodeConfigurationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedNodeConfigurationOption> {
        /**
         * Sets the value of the SourceReservedNode property for this object.
         *
         * @param sourceReservedNode
         *        The new value for the SourceReservedNode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReservedNode(ReservedNode sourceReservedNode);

        /**
         * Sets the value of the SourceReservedNode property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ReservedNode.Builder} avoiding the need
         * to create one manually via {@link ReservedNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedNode.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceReservedNode(ReservedNode)}.
         * 
         * @param sourceReservedNode
         *        a consumer that will call methods on {@link ReservedNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceReservedNode(ReservedNode)
         */
        default Builder sourceReservedNode(Consumer<ReservedNode.Builder> sourceReservedNode) {
            return sourceReservedNode(ReservedNode.builder().applyMutation(sourceReservedNode).build());
        }

        /**
         * <p>
         * The target reserved-node count.
         * </p>
         * 
         * @param targetReservedNodeCount
         *        The target reserved-node count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeCount(Integer targetReservedNodeCount);

        /**
         * Sets the value of the TargetReservedNodeOffering property for this object.
         *
         * @param targetReservedNodeOffering
         *        The new value for the TargetReservedNodeOffering property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeOffering(ReservedNodeOffering targetReservedNodeOffering);

        /**
         * Sets the value of the TargetReservedNodeOffering property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ReservedNodeOffering.Builder} avoiding
         * the need to create one manually via {@link ReservedNodeOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedNodeOffering.Builder#build()} is called immediately and
         * its result is passed to {@link #targetReservedNodeOffering(ReservedNodeOffering)}.
         * 
         * @param targetReservedNodeOffering
         *        a consumer that will call methods on {@link ReservedNodeOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetReservedNodeOffering(ReservedNodeOffering)
         */
        default Builder targetReservedNodeOffering(Consumer<ReservedNodeOffering.Builder> targetReservedNodeOffering) {
            return targetReservedNodeOffering(ReservedNodeOffering.builder().applyMutation(targetReservedNodeOffering).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReservedNode sourceReservedNode;

        private Integer targetReservedNodeCount;

        private ReservedNodeOffering targetReservedNodeOffering;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNodeConfigurationOption model) {
            sourceReservedNode(model.sourceReservedNode);
            targetReservedNodeCount(model.targetReservedNodeCount);
            targetReservedNodeOffering(model.targetReservedNodeOffering);
        }

        public final ReservedNode.Builder getSourceReservedNode() {
            return sourceReservedNode != null ? sourceReservedNode.toBuilder() : null;
        }

        public final void setSourceReservedNode(ReservedNode.BuilderImpl sourceReservedNode) {
            this.sourceReservedNode = sourceReservedNode != null ? sourceReservedNode.build() : null;
        }

        @Override
        public final Builder sourceReservedNode(ReservedNode sourceReservedNode) {
            this.sourceReservedNode = sourceReservedNode;
            return this;
        }

        public final Integer getTargetReservedNodeCount() {
            return targetReservedNodeCount;
        }

        public final void setTargetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
        }

        @Override
        public final Builder targetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
            return this;
        }

        public final ReservedNodeOffering.Builder getTargetReservedNodeOffering() {
            return targetReservedNodeOffering != null ? targetReservedNodeOffering.toBuilder() : null;
        }

        public final void setTargetReservedNodeOffering(ReservedNodeOffering.BuilderImpl targetReservedNodeOffering) {
            this.targetReservedNodeOffering = targetReservedNodeOffering != null ? targetReservedNodeOffering.build() : null;
        }

        @Override
        public final Builder targetReservedNodeOffering(ReservedNodeOffering targetReservedNodeOffering) {
            this.targetReservedNodeOffering = targetReservedNodeOffering;
            return this;
        }

        @Override
        public ReservedNodeConfigurationOption build() {
            return new ReservedNodeConfigurationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
