/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of scopes set up for S3 Access Grants integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3AccessGrantsScopeUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<S3AccessGrantsScopeUnion.Builder, S3AccessGrantsScopeUnion> {
    private static final SdkField<ReadWriteAccess> READ_WRITE_ACCESS_FIELD = SdkField
            .<ReadWriteAccess> builder(MarshallingType.SDK_POJO).memberName("ReadWriteAccess")
            .getter(getter(S3AccessGrantsScopeUnion::readWriteAccess)).setter(setter(Builder::readWriteAccess))
            .constructor(ReadWriteAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadWriteAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_WRITE_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReadWriteAccess readWriteAccess;

    private final Type type;

    private S3AccessGrantsScopeUnion(BuilderImpl builder) {
        this.readWriteAccess = builder.readWriteAccess;
        this.type = builder.type;
    }

    /**
     * <p>
     * The S3 Access Grants scope.
     * </p>
     * 
     * @return The S3 Access Grants scope.
     */
    public final ReadWriteAccess readWriteAccess() {
        return readWriteAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readWriteAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessGrantsScopeUnion)) {
            return false;
        }
        S3AccessGrantsScopeUnion other = (S3AccessGrantsScopeUnion) obj;
        return Objects.equals(readWriteAccess(), other.readWriteAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3AccessGrantsScopeUnion").add("ReadWriteAccess", readWriteAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadWriteAccess":
            return Optional.ofNullable(clazz.cast(readWriteAccess()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #readWriteAccess()} initialized to the given value.
     *
     * <p>
     * The S3 Access Grants scope.
     * </p>
     * 
     * @param readWriteAccess
     *        The S3 Access Grants scope.
     */
    public static S3AccessGrantsScopeUnion fromReadWriteAccess(ReadWriteAccess readWriteAccess) {
        return builder().readWriteAccess(readWriteAccess).build();
    }

    /**
     * Create an instance of this class with {@link #readWriteAccess()} initialized to the given value.
     *
     * <p>
     * The S3 Access Grants scope.
     * </p>
     * 
     * @param readWriteAccess
     *        The S3 Access Grants scope.
     */
    public static S3AccessGrantsScopeUnion fromReadWriteAccess(Consumer<ReadWriteAccess.Builder> readWriteAccess) {
        ReadWriteAccess.Builder builder = ReadWriteAccess.builder();
        readWriteAccess.accept(builder);
        return fromReadWriteAccess(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReadWriteAccess", READ_WRITE_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessGrantsScopeUnion, T> g) {
        return obj -> g.apply((S3AccessGrantsScopeUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3AccessGrantsScopeUnion> {
        /**
         * <p>
         * The S3 Access Grants scope.
         * </p>
         * 
         * @param readWriteAccess
         *        The S3 Access Grants scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readWriteAccess(ReadWriteAccess readWriteAccess);

        /**
         * <p>
         * The S3 Access Grants scope.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadWriteAccess.Builder} avoiding the
         * need to create one manually via {@link ReadWriteAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadWriteAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #readWriteAccess(ReadWriteAccess)}.
         * 
         * @param readWriteAccess
         *        a consumer that will call methods on {@link ReadWriteAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readWriteAccess(ReadWriteAccess)
         */
        default Builder readWriteAccess(Consumer<ReadWriteAccess.Builder> readWriteAccess) {
            return readWriteAccess(ReadWriteAccess.builder().applyMutation(readWriteAccess).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReadWriteAccess readWriteAccess;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessGrantsScopeUnion model) {
            readWriteAccess(model.readWriteAccess);
        }

        public final ReadWriteAccess.Builder getReadWriteAccess() {
            return readWriteAccess != null ? readWriteAccess.toBuilder() : null;
        }

        public final void setReadWriteAccess(ReadWriteAccess.BuilderImpl readWriteAccess) {
            Object oldValue = this.readWriteAccess;
            this.readWriteAccess = readWriteAccess != null ? readWriteAccess.build() : null;
            handleUnionValueChange(Type.READ_WRITE_ACCESS, oldValue, this.readWriteAccess);
        }

        @Override
        public final Builder readWriteAccess(ReadWriteAccess readWriteAccess) {
            Object oldValue = this.readWriteAccess;
            this.readWriteAccess = readWriteAccess;
            handleUnionValueChange(Type.READ_WRITE_ACCESS, oldValue, this.readWriteAccess);
            return this;
        }

        @Override
        public S3AccessGrantsScopeUnion build() {
            return new S3AccessGrantsScopeUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see S3AccessGrantsScopeUnion#type()
     */
    public enum Type {
        READ_WRITE_ACCESS,

        UNKNOWN_TO_SDK_VERSION
    }
}
