/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of service integrations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceIntegrationsUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceIntegrationsUnion.Builder, ServiceIntegrationsUnion> {
    private static final SdkField<List<LakeFormationScopeUnion>> LAKE_FORMATION_FIELD = SdkField
            .<List<LakeFormationScopeUnion>> builder(MarshallingType.LIST)
            .memberName("LakeFormation")
            .getter(getter(ServiceIntegrationsUnion::lakeFormation))
            .setter(setter(Builder::lakeFormation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormation").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LakeFormationScopeUnion> builder(MarshallingType.SDK_POJO)
                                            .constructor(LakeFormationScopeUnion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<S3AccessGrantsScopeUnion>> S3_ACCESS_GRANTS_FIELD = SdkField
            .<List<S3AccessGrantsScopeUnion>> builder(MarshallingType.LIST)
            .memberName("S3AccessGrants")
            .getter(getter(ServiceIntegrationsUnion::s3AccessGrants))
            .setter(setter(Builder::s3AccessGrants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessGrants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3AccessGrantsScopeUnion> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3AccessGrantsScopeUnion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAKE_FORMATION_FIELD,
            S3_ACCESS_GRANTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LakeFormationScopeUnion> lakeFormation;

    private final List<S3AccessGrantsScopeUnion> s3AccessGrants;

    private final Type type;

    private ServiceIntegrationsUnion(BuilderImpl builder) {
        this.lakeFormation = builder.lakeFormation;
        this.s3AccessGrants = builder.s3AccessGrants;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the LakeFormation property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLakeFormation() {
        return lakeFormation != null && !(lakeFormation instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of scopes set up for Lake Formation integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLakeFormation} method.
     * </p>
     * 
     * @return A list of scopes set up for Lake Formation integration.
     */
    public final List<LakeFormationScopeUnion> lakeFormation() {
        return lakeFormation;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3AccessGrants property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3AccessGrants() {
        return s3AccessGrants != null && !(s3AccessGrants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of scopes set up for S3 Access Grants integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3AccessGrants} method.
     * </p>
     * 
     * @return A list of scopes set up for S3 Access Grants integration.
     */
    public final List<S3AccessGrantsScopeUnion> s3AccessGrants() {
        return s3AccessGrants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLakeFormation() ? lakeFormation() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasS3AccessGrants() ? s3AccessGrants() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceIntegrationsUnion)) {
            return false;
        }
        ServiceIntegrationsUnion other = (ServiceIntegrationsUnion) obj;
        return hasLakeFormation() == other.hasLakeFormation() && Objects.equals(lakeFormation(), other.lakeFormation())
                && hasS3AccessGrants() == other.hasS3AccessGrants() && Objects.equals(s3AccessGrants(), other.s3AccessGrants());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceIntegrationsUnion").add("LakeFormation", hasLakeFormation() ? lakeFormation() : null)
                .add("S3AccessGrants", hasS3AccessGrants() ? s3AccessGrants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LakeFormation":
            return Optional.ofNullable(clazz.cast(lakeFormation()));
        case "S3AccessGrants":
            return Optional.ofNullable(clazz.cast(s3AccessGrants()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #lakeFormation()} initialized to the given value.
     *
     * <p>
     * A list of scopes set up for Lake Formation integration.
     * </p>
     * 
     * @param lakeFormation
     *        A list of scopes set up for Lake Formation integration.
     */
    public static ServiceIntegrationsUnion fromLakeFormation(List<LakeFormationScopeUnion> lakeFormation) {
        return builder().lakeFormation(lakeFormation).build();
    }

    /**
     * Create an instance of this class with {@link #s3AccessGrants()} initialized to the given value.
     *
     * <p>
     * A list of scopes set up for S3 Access Grants integration.
     * </p>
     * 
     * @param s3AccessGrants
     *        A list of scopes set up for S3 Access Grants integration.
     */
    public static ServiceIntegrationsUnion fromS3AccessGrants(List<S3AccessGrantsScopeUnion> s3AccessGrants) {
        return builder().s3AccessGrants(s3AccessGrants).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LakeFormation", LAKE_FORMATION_FIELD);
        map.put("S3AccessGrants", S3_ACCESS_GRANTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceIntegrationsUnion, T> g) {
        return obj -> g.apply((ServiceIntegrationsUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceIntegrationsUnion> {
        /**
         * <p>
         * A list of scopes set up for Lake Formation integration.
         * </p>
         * 
         * @param lakeFormation
         *        A list of scopes set up for Lake Formation integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormation(Collection<LakeFormationScopeUnion> lakeFormation);

        /**
         * <p>
         * A list of scopes set up for Lake Formation integration.
         * </p>
         * 
         * @param lakeFormation
         *        A list of scopes set up for Lake Formation integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormation(LakeFormationScopeUnion... lakeFormation);

        /**
         * <p>
         * A list of scopes set up for Lake Formation integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.LakeFormationScopeUnion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.LakeFormationScopeUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.LakeFormationScopeUnion.Builder#build()} is called
         * immediately and its result is passed to {@link #lakeFormation(List<LakeFormationScopeUnion>)}.
         * 
         * @param lakeFormation
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.LakeFormationScopeUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lakeFormation(java.util.Collection<LakeFormationScopeUnion>)
         */
        Builder lakeFormation(Consumer<LakeFormationScopeUnion.Builder>... lakeFormation);

        /**
         * <p>
         * A list of scopes set up for S3 Access Grants integration.
         * </p>
         * 
         * @param s3AccessGrants
         *        A list of scopes set up for S3 Access Grants integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessGrants(Collection<S3AccessGrantsScopeUnion> s3AccessGrants);

        /**
         * <p>
         * A list of scopes set up for S3 Access Grants integration.
         * </p>
         * 
         * @param s3AccessGrants
         *        A list of scopes set up for S3 Access Grants integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessGrants(S3AccessGrantsScopeUnion... s3AccessGrants);

        /**
         * <p>
         * A list of scopes set up for S3 Access Grants integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.S3AccessGrantsScopeUnion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.S3AccessGrantsScopeUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.S3AccessGrantsScopeUnion.Builder#build()} is called
         * immediately and its result is passed to {@link #s3AccessGrants(List<S3AccessGrantsScopeUnion>)}.
         * 
         * @param s3AccessGrants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.S3AccessGrantsScopeUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3AccessGrants(java.util.Collection<S3AccessGrantsScopeUnion>)
         */
        Builder s3AccessGrants(Consumer<S3AccessGrantsScopeUnion.Builder>... s3AccessGrants);
    }

    static final class BuilderImpl implements Builder {
        private List<LakeFormationScopeUnion> lakeFormation = DefaultSdkAutoConstructList.getInstance();

        private List<S3AccessGrantsScopeUnion> s3AccessGrants = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceIntegrationsUnion model) {
            lakeFormation(model.lakeFormation);
            s3AccessGrants(model.s3AccessGrants);
        }

        public final List<LakeFormationScopeUnion.Builder> getLakeFormation() {
            List<LakeFormationScopeUnion.Builder> result = LakeFormationServiceIntegrationsCopier
                    .copyToBuilder(this.lakeFormation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLakeFormation(Collection<LakeFormationScopeUnion.BuilderImpl> lakeFormation) {
            Object oldValue = this.lakeFormation;
            this.lakeFormation = LakeFormationServiceIntegrationsCopier.copyFromBuilder(lakeFormation);
            handleUnionValueChange(Type.LAKE_FORMATION, oldValue, this.lakeFormation);
        }

        @Override
        public final Builder lakeFormation(Collection<LakeFormationScopeUnion> lakeFormation) {
            Object oldValue = this.lakeFormation;
            this.lakeFormation = LakeFormationServiceIntegrationsCopier.copy(lakeFormation);
            handleUnionValueChange(Type.LAKE_FORMATION, oldValue, this.lakeFormation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormation(LakeFormationScopeUnion... lakeFormation) {
            lakeFormation(Arrays.asList(lakeFormation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormation(Consumer<LakeFormationScopeUnion.Builder>... lakeFormation) {
            lakeFormation(Stream.of(lakeFormation).map(c -> LakeFormationScopeUnion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<S3AccessGrantsScopeUnion.Builder> getS3AccessGrants() {
            List<S3AccessGrantsScopeUnion.Builder> result = S3AccessGrantsServiceIntegrationsCopier
                    .copyToBuilder(this.s3AccessGrants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3AccessGrants(Collection<S3AccessGrantsScopeUnion.BuilderImpl> s3AccessGrants) {
            Object oldValue = this.s3AccessGrants;
            this.s3AccessGrants = S3AccessGrantsServiceIntegrationsCopier.copyFromBuilder(s3AccessGrants);
            handleUnionValueChange(Type.S3_ACCESS_GRANTS, oldValue, this.s3AccessGrants);
        }

        @Override
        public final Builder s3AccessGrants(Collection<S3AccessGrantsScopeUnion> s3AccessGrants) {
            Object oldValue = this.s3AccessGrants;
            this.s3AccessGrants = S3AccessGrantsServiceIntegrationsCopier.copy(s3AccessGrants);
            handleUnionValueChange(Type.S3_ACCESS_GRANTS, oldValue, this.s3AccessGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3AccessGrants(S3AccessGrantsScopeUnion... s3AccessGrants) {
            s3AccessGrants(Arrays.asList(s3AccessGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3AccessGrants(Consumer<S3AccessGrantsScopeUnion.Builder>... s3AccessGrants) {
            s3AccessGrants(Stream.of(s3AccessGrants).map(c -> S3AccessGrantsScopeUnion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceIntegrationsUnion build() {
            return new ServiceIntegrationsUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ServiceIntegrationsUnion#type()
     */
    public enum Type {
        LAKE_FORMATION,

        S3_ACCESS_GRANTS,

        UNKNOWN_TO_SDK_VERSION
    }
}
