/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.model.Field;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;

public class GetStatementResultIterable
implements SdkIterable<GetStatementResultResponse> {
    private final RedshiftDataClient client;
    private final GetStatementResultRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetStatementResultIterable(RedshiftDataClient client, GetStatementResultRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetStatementResultResponseFetcher();
    }

    public Iterator<GetStatementResultResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<List<Field>> records() {
        Function<GetStatementResultResponse, Iterator> getIterator = response -> {
            if (response != null && response.records() != null) {
                return response.records().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetStatementResultResponseFetcher
    implements SyncPageFetcher<GetStatementResultResponse> {
        private GetStatementResultResponseFetcher() {
        }

        public boolean hasNextPage(GetStatementResultResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetStatementResultResponse nextPage(GetStatementResultResponse previousPage) {
            if (previousPage == null) {
                return GetStatementResultIterable.this.client.getStatementResult(GetStatementResultIterable.this.firstRequest);
            }
            return GetStatementResultIterable.this.client.getStatementResult((GetStatementResultRequest)((Object)GetStatementResultIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

