/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.OperationSummary;

public class ListOperationsIterable
implements SdkIterable<ListOperationsResponse> {
    private final Route53DomainsClient client;
    private final ListOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOperationsIterable(Route53DomainsClient client, ListOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public Iterator<ListOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OperationSummary> operations() {
        Function<ListOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.operations() != null) {
                return response.operations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOperationsResponseFetcher
    implements SyncPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageMarker());
        }

        public ListOperationsResponse nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsIterable.this.client.listOperations(ListOperationsIterable.this.firstRequest);
            }
            return ListOperationsIterable.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsIterable.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

