/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.serialization;

import java.io.InputStream;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerJsonMarshaller;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerJsonUnmarshaller;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerMarshallingUtils;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ResumableFileUploadSerializer {
    private static final Logger log = Logger.loggerFor(S3TransferManager.class);
    private static final String MULTIPART_UPLOAD_ID = "multipartUploadId";
    private static final String FILE_LENGTH = "fileLength";
    private static final String FILE_LAST_MODIFIED = "fileLastModified";
    private static final String PART_SIZE_IN_BYTES = "partSizeInBytes";
    private static final String TOTAL_PARTS = "totalParts";
    private static final String TRANSFERRED_PARTS = "transferredParts";
    private static final String UPLOAD_FILE_REQUEST = "uploadFileRequest";
    private static final String SOURCE = "source";
    private static final String PUT_OBJECT_REQUEST = "putObjectRequest";

    private ResumableFileUploadSerializer() {
    }

    public static byte[] toJson(ResumableFileUpload upload) {
        JsonWriter jsonGenerator = JsonWriter.create();
        jsonGenerator.writeStartObject();
        TransferManagerJsonMarshaller.LONG.marshall(upload.fileLength(), jsonGenerator, FILE_LENGTH);
        TransferManagerJsonMarshaller.INSTANT.marshall(upload.fileLastModified(), jsonGenerator, FILE_LAST_MODIFIED);
        if (upload.multipartUploadId().isPresent()) {
            TransferManagerJsonMarshaller.STRING.marshall(upload.multipartUploadId().get(), jsonGenerator, MULTIPART_UPLOAD_ID);
        }
        if (upload.partSizeInBytes().isPresent()) {
            TransferManagerJsonMarshaller.LONG.marshall(upload.partSizeInBytes().getAsLong(), jsonGenerator, PART_SIZE_IN_BYTES);
        }
        if (upload.totalParts().isPresent()) {
            TransferManagerJsonMarshaller.LONG.marshall(upload.totalParts().getAsLong(), jsonGenerator, TOTAL_PARTS);
        }
        if (upload.transferredParts().isPresent()) {
            TransferManagerJsonMarshaller.LONG.marshall(upload.transferredParts().getAsLong(), jsonGenerator, TRANSFERRED_PARTS);
        }
        ResumableFileUploadSerializer.marshallUploadFileRequest(upload.uploadFileRequest(), jsonGenerator);
        jsonGenerator.writeEndObject();
        return jsonGenerator.getBytes();
    }

    private static void marshallUploadFileRequest(UploadFileRequest fileRequest, JsonWriter jsonGenerator) {
        jsonGenerator.writeFieldName(UPLOAD_FILE_REQUEST);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName(SOURCE);
        jsonGenerator.writeValue(fileRequest.source().toString());
        ResumableFileUploadSerializer.marshallPutObjectRequest(fileRequest.putObjectRequest(), jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private static void marshallPutObjectRequest(PutObjectRequest putObjectRequest, JsonWriter jsonGenerator) {
        jsonGenerator.writeFieldName(PUT_OBJECT_REQUEST);
        jsonGenerator.writeStartObject();
        ResumableFileUploadSerializer.validateNoRequestOverrideConfiguration(putObjectRequest);
        putObjectRequest.sdkFields().forEach(field -> ResumableFileUploadSerializer.marshallPojoField(field, putObjectRequest, jsonGenerator));
        jsonGenerator.writeEndObject();
    }

    private static void validateNoRequestOverrideConfiguration(PutObjectRequest putObjectRequest) {
        if (putObjectRequest.overrideConfiguration().isPresent()) {
            log.debug(() -> "ResumableFileUpload PutObjectRequest contains an override configuration that will not be serialized");
        }
    }

    private static void marshallPojoField(SdkField<?> field, PutObjectRequest request, JsonWriter jsonGenerator) {
        Object val = field.getValueOrDefault((Object)request);
        TransferManagerJsonMarshaller<Object> marshaller = TransferManagerMarshallingUtils.getMarshaller(field.marshallingType(), val);
        marshaller.marshall(val, jsonGenerator, field.locationName());
    }

    public static ResumableFileUpload fromJson(String bytes) {
        JsonNodeParser jsonNodeParser = JsonNodeParser.builder().build();
        Map uploadNodes = jsonNodeParser.parse(bytes).asObject();
        return ResumableFileUploadSerializer.fromNodes(uploadNodes);
    }

    public static ResumableFileUpload fromJson(byte[] string) {
        JsonNodeParser jsonNodeParser = JsonNodeParser.builder().build();
        Map uploadNodes = jsonNodeParser.parse(string).asObject();
        return ResumableFileUploadSerializer.fromNodes(uploadNodes);
    }

    public static ResumableFileUpload fromJson(InputStream inputStream) {
        JsonNodeParser jsonNodeParser = JsonNodeParser.builder().build();
        Map uploadNodes = jsonNodeParser.parse(inputStream).asObject();
        return ResumableFileUploadSerializer.fromNodes(uploadNodes);
    }

    private static ResumableFileUpload fromNodes(Map<String, JsonNode> uploadNodes) {
        TransferManagerJsonUnmarshaller<?> longUnmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(MarshallingType.LONG);
        TransferManagerJsonUnmarshaller<?> instantUnmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(MarshallingType.INSTANT);
        TransferManagerJsonUnmarshaller<?> stringUnmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(MarshallingType.STRING);
        ResumableFileUpload.Builder builder = ResumableFileUpload.builder();
        JsonNode fileLength = (JsonNode)Validate.paramNotNull((Object)uploadNodes.get(FILE_LENGTH), (String)FILE_LENGTH);
        builder.fileLength((Long)longUnmarshaller.unmarshall(fileLength));
        JsonNode fileLastModified = (JsonNode)Validate.paramNotNull((Object)uploadNodes.get(FILE_LAST_MODIFIED), (String)FILE_LAST_MODIFIED);
        builder.fileLastModified((Instant)instantUnmarshaller.unmarshall(fileLastModified));
        if (uploadNodes.get(MULTIPART_UPLOAD_ID) != null) {
            builder.multipartUploadId((String)stringUnmarshaller.unmarshall(uploadNodes.get(MULTIPART_UPLOAD_ID)));
        }
        if (uploadNodes.get(PART_SIZE_IN_BYTES) != null) {
            builder.partSizeInBytes((Long)longUnmarshaller.unmarshall(uploadNodes.get(PART_SIZE_IN_BYTES)));
        }
        if (uploadNodes.get(TOTAL_PARTS) != null) {
            builder.totalParts((Long)longUnmarshaller.unmarshall(uploadNodes.get(TOTAL_PARTS)));
        }
        if (uploadNodes.get(TRANSFERRED_PARTS) != null) {
            builder.transferredParts((Long)longUnmarshaller.unmarshall(uploadNodes.get(TRANSFERRED_PARTS)));
        }
        JsonNode jsonNode = (JsonNode)Validate.paramNotNull((Object)uploadNodes.get(UPLOAD_FILE_REQUEST), (String)UPLOAD_FILE_REQUEST);
        builder.uploadFileRequest(ResumableFileUploadSerializer.parseUploadFileRequest(jsonNode));
        return (ResumableFileUpload)builder.build();
    }

    private static UploadFileRequest parseUploadFileRequest(JsonNode fileRequest) {
        UploadFileRequest.Builder fileRequestBuilder = UploadFileRequest.builder();
        Map fileRequestNodes = fileRequest.asObject();
        fileRequestBuilder.source(Paths.get(((JsonNode)fileRequestNodes.get(SOURCE)).asString(), new String[0]));
        PutObjectRequest.Builder putObjectBuilder = PutObjectRequest.builder();
        Map putObjectRequestNodes = ((JsonNode)fileRequestNodes.get(PUT_OBJECT_REQUEST)).asObject();
        putObjectRequestNodes.forEach((key, value) -> ResumableFileUploadSerializer.setPutObjectParameters(putObjectBuilder, key, value));
        fileRequestBuilder.putObjectRequest((PutObjectRequest)putObjectBuilder.build());
        return (UploadFileRequest)fileRequestBuilder.build();
    }

    private static void setPutObjectParameters(PutObjectRequest.Builder putObjectBuilder, String key, JsonNode value) {
        SdkField<?> f = TransferManagerMarshallingUtils.putObjectSdkField(key);
        MarshallingType marshallingType = f.marshallingType();
        TransferManagerJsonUnmarshaller<?> unmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(marshallingType);
        f.set((Object)putObjectBuilder, unmarshaller.unmarshall(value, f));
    }
}

