/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecretsResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<ListSecretsResponse.Builder, ListSecretsResponse> {
    private static final SdkField<List<SecretListEntry>> SECRET_LIST_FIELD = SdkField
            .<List<SecretListEntry>> builder(MarshallingType.LIST)
            .memberName("SecretList")
            .getter(getter(ListSecretsResponse::secretList))
            .setter(setter(Builder::secretList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecretListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecretListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSecretsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SecretListEntry> secretList;

    private final String nextToken;

    private ListSecretsResponse(BuilderImpl builder) {
        super(builder);
        this.secretList = builder.secretList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecretList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSecretList() {
        return secretList != null && !(secretList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the secrets in the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecretList} method.
     * </p>
     * 
     * @return A list of the secrets in the account.
     */
    public final List<SecretListEntry> secretList() {
        return secretList;
    }

    /**
     * <p>
     * Secrets Manager includes this value if there's more output available than what is included in the current
     * response. This can occur even when the response includes no values at all, such as when you ask for a filtered
     * view of a long list. To get the next results, call <code>ListSecrets</code> again with this value.
     * </p>
     * 
     * @return Secrets Manager includes this value if there's more output available than what is included in the current
     *         response. This can occur even when the response includes no values at all, such as when you ask for a
     *         filtered view of a long list. To get the next results, call <code>ListSecrets</code> again with this
     *         value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecretList() ? secretList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretsResponse)) {
            return false;
        }
        ListSecretsResponse other = (ListSecretsResponse) obj;
        return hasSecretList() == other.hasSecretList() && Objects.equals(secretList(), other.secretList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecretsResponse").add("SecretList", hasSecretList() ? secretList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretList":
            return Optional.ofNullable(clazz.cast(secretList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecretsResponse, T> g) {
        return obj -> g.apply((ListSecretsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSecretsResponse> {
        /**
         * <p>
         * A list of the secrets in the account.
         * </p>
         * 
         * @param secretList
         *        A list of the secrets in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretList(Collection<SecretListEntry> secretList);

        /**
         * <p>
         * A list of the secrets in the account.
         * </p>
         * 
         * @param secretList
         *        A list of the secrets in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretList(SecretListEntry... secretList);

        /**
         * <p>
         * A list of the secrets in the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.secretsmanager.model.SecretListEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.secretsmanager.model.SecretListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.secretsmanager.model.SecretListEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #secretList(List<SecretListEntry>)}.
         * 
         * @param secretList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.secretsmanager.model.SecretListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretList(java.util.Collection<SecretListEntry>)
         */
        Builder secretList(Consumer<SecretListEntry.Builder>... secretList);

        /**
         * <p>
         * Secrets Manager includes this value if there's more output available than what is included in the current
         * response. This can occur even when the response includes no values at all, such as when you ask for a
         * filtered view of a long list. To get the next results, call <code>ListSecrets</code> again with this value.
         * </p>
         * 
         * @param nextToken
         *        Secrets Manager includes this value if there's more output available than what is included in the
         *        current response. This can occur even when the response includes no values at all, such as when you
         *        ask for a filtered view of a long list. To get the next results, call <code>ListSecrets</code> again
         *        with this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private List<SecretListEntry> secretList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecretsResponse model) {
            super(model);
            secretList(model.secretList);
            nextToken(model.nextToken);
        }

        public final List<SecretListEntry.Builder> getSecretList() {
            List<SecretListEntry.Builder> result = SecretListTypeCopier.copyToBuilder(this.secretList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecretList(Collection<SecretListEntry.BuilderImpl> secretList) {
            this.secretList = SecretListTypeCopier.copyFromBuilder(secretList);
        }

        @Override
        public final Builder secretList(Collection<SecretListEntry> secretList) {
            this.secretList = SecretListTypeCopier.copy(secretList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretList(SecretListEntry... secretList) {
            secretList(Arrays.asList(secretList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretList(Consumer<SecretListEntry.Builder>... secretList) {
            secretList(Stream.of(secretList).map(c -> SecretListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecretsResponse build() {
            return new ListSecretsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
