/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.EventSummary;
import software.amazon.awssdk.services.ssmincidents.model.EventSummaryListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTimelineEventsResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, ListTimelineEventsResponse> {
    private static final SdkField<List<EventSummary>> EVENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventSummaries").getter(ListTimelineEventsResponse.getter(ListTimelineEventsResponse::eventSummaries)).setter(ListTimelineEventsResponse.setter(Builder::eventSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTimelineEventsResponse.getter(ListTimelineEventsResponse::nextToken)).setter(ListTimelineEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventSummaries", EVENT_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<EventSummary> eventSummaries;
    private final String nextToken;

    private ListTimelineEventsResponse(BuilderImpl builder) {
        super(builder);
        this.eventSummaries = builder.eventSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventSummaries() {
        return this.eventSummaries != null && !(this.eventSummaries instanceof SdkAutoConstructList);
    }

    public final List<EventSummary> eventSummaries() {
        return this.eventSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventSummaries() ? this.eventSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimelineEventsResponse)) {
            return false;
        }
        ListTimelineEventsResponse other = (ListTimelineEventsResponse)((Object)obj);
        return this.hasEventSummaries() == other.hasEventSummaries() && Objects.equals(this.eventSummaries(), other.eventSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTimelineEventsResponse").add("EventSummaries", this.hasEventSummaries() ? this.eventSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventSummaries": {
                return Optional.ofNullable(clazz.cast(this.eventSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTimelineEventsResponse, T> g) {
        return obj -> g.apply((ListTimelineEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private List<EventSummary> eventSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTimelineEventsResponse model) {
            super(model);
            this.eventSummaries(model.eventSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<EventSummary.Builder> getEventSummaries() {
            List<EventSummary.Builder> result = EventSummaryListCopier.copyToBuilder(this.eventSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSummaries(Collection<EventSummary.BuilderImpl> eventSummaries) {
            this.eventSummaries = EventSummaryListCopier.copyFromBuilder(eventSummaries);
        }

        @Override
        public final Builder eventSummaries(Collection<EventSummary> eventSummaries) {
            this.eventSummaries = EventSummaryListCopier.copy(eventSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSummaries(EventSummary ... eventSummaries) {
            this.eventSummaries(Arrays.asList(eventSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSummaries(Consumer<EventSummary.Builder> ... eventSummaries) {
            this.eventSummaries(Stream.of(eventSummaries).map(c -> (EventSummary)((EventSummary.Builder)EventSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTimelineEventsResponse build() {
            return new ListTimelineEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTimelineEventsResponse> {
        public Builder eventSummaries(Collection<EventSummary> var1);

        public Builder eventSummaries(EventSummary ... var1);

        public Builder eventSummaries(Consumer<EventSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

