/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmincidents.model.RegionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionInfo> {
    private static final SdkField<String> SSE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sseKmsKeyId").getter(RegionInfo.getter(RegionInfo::sseKmsKeyId)).setter(RegionInfo.setter(Builder::sseKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseKmsKeyId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RegionInfo.getter(RegionInfo::statusAsString)).setter(RegionInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(RegionInfo.getter(RegionInfo::statusMessage)).setter(RegionInfo.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> STATUS_UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("statusUpdateDateTime").getter(RegionInfo.getter(RegionInfo::statusUpdateDateTime)).setter(RegionInfo.setter(Builder::statusUpdateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSE_KMS_KEY_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STATUS_UPDATE_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sseKmsKeyId", SSE_KMS_KEY_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusMessage", STATUS_MESSAGE_FIELD);
            this.put("statusUpdateDateTime", STATUS_UPDATE_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sseKmsKeyId;
    private final String status;
    private final String statusMessage;
    private final Instant statusUpdateDateTime;

    private RegionInfo(BuilderImpl builder) {
        this.sseKmsKeyId = builder.sseKmsKeyId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.statusUpdateDateTime = builder.statusUpdateDateTime;
    }

    public final String sseKmsKeyId() {
        return this.sseKmsKeyId;
    }

    public final RegionStatus status() {
        return RegionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant statusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sseKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionInfo)) {
            return false;
        }
        RegionInfo other = (RegionInfo)obj;
        return Objects.equals(this.sseKmsKeyId(), other.sseKmsKeyId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.statusUpdateDateTime(), other.statusUpdateDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"RegionInfo").add("SseKmsKeyId", (Object)this.sseKmsKeyId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StatusUpdateDateTime", (Object)this.statusUpdateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sseKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.sseKmsKeyId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "statusUpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegionInfo, T> g) {
        return obj -> g.apply((RegionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sseKmsKeyId;
        private String status;
        private String statusMessage;
        private Instant statusUpdateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionInfo model) {
            this.sseKmsKeyId(model.sseKmsKeyId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.statusUpdateDateTime(model.statusUpdateDateTime);
        }

        public final String getSseKmsKeyId() {
            return this.sseKmsKeyId;
        }

        public final void setSseKmsKeyId(String sseKmsKeyId) {
            this.sseKmsKeyId = sseKmsKeyId;
        }

        @Override
        public final Builder sseKmsKeyId(String sseKmsKeyId) {
            this.sseKmsKeyId = sseKmsKeyId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStatusUpdateDateTime() {
            return this.statusUpdateDateTime;
        }

        public final void setStatusUpdateDateTime(Instant statusUpdateDateTime) {
            this.statusUpdateDateTime = statusUpdateDateTime;
        }

        @Override
        public final Builder statusUpdateDateTime(Instant statusUpdateDateTime) {
            this.statusUpdateDateTime = statusUpdateDateTime;
            return this;
        }

        public RegionInfo build() {
            return new RegionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionInfo> {
        public Builder sseKmsKeyId(String var1);

        public Builder status(String var1);

        public Builder status(RegionStatus var1);

        public Builder statusMessage(String var1);

        public Builder statusUpdateDateTime(Instant var1);
    }
}

