/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.RegionInfo;
import software.amazon.awssdk.services.ssmincidents.model.RegionInfoMapCopier;
import software.amazon.awssdk.services.ssmincidents.model.ReplicationSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationSet> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ReplicationSet.getter(ReplicationSet::arn)).setter(ReplicationSet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(ReplicationSet.getter(ReplicationSet::createdBy)).setter(ReplicationSet.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(ReplicationSet.getter(ReplicationSet::createdTime)).setter(ReplicationSet.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtected").getter(ReplicationSet.getter(ReplicationSet::deletionProtected)).setter(ReplicationSet.setter(Builder::deletionProtected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtected").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedBy").getter(ReplicationSet.getter(ReplicationSet::lastModifiedBy)).setter(ReplicationSet.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(ReplicationSet.getter(ReplicationSet::lastModifiedTime)).setter(ReplicationSet.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<Map<String, RegionInfo>> REGION_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("regionMap").getter(ReplicationSet.getter(ReplicationSet::regionMap)).setter(ReplicationSet.setter(Builder::regionMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ReplicationSet.getter(ReplicationSet::statusAsString)).setter(ReplicationSet.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_BY_FIELD, CREATED_TIME_FIELD, DELETION_PROTECTED_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, REGION_MAP_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("deletionProtected", DELETION_PROTECTED_FIELD);
            this.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
            this.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("regionMap", REGION_MAP_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String createdBy;
    private final Instant createdTime;
    private final Boolean deletionProtected;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final Map<String, RegionInfo> regionMap;
    private final String status;

    private ReplicationSet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
        this.deletionProtected = builder.deletionProtected;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.regionMap = builder.regionMap;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Boolean deletionProtected() {
        return this.deletionProtected;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasRegionMap() {
        return this.regionMap != null && !(this.regionMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, RegionInfo> regionMap() {
        return this.regionMap;
    }

    public final ReplicationSetStatus status() {
        return ReplicationSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtected());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionMap() ? this.regionMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSet)) {
            return false;
        }
        ReplicationSet other = (ReplicationSet)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.deletionProtected(), other.deletionProtected()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasRegionMap() == other.hasRegionMap() && Objects.equals(this.regionMap(), other.regionMap()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationSet").add("Arn", (Object)this.arn()).add("CreatedBy", (Object)this.createdBy()).add("CreatedTime", (Object)this.createdTime()).add("DeletionProtected", (Object)this.deletionProtected()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("RegionMap", this.hasRegionMap() ? this.regionMap() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "deletionProtected": {
                return Optional.ofNullable(clazz.cast(this.deletionProtected()));
            }
            case "lastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "regionMap": {
                return Optional.ofNullable(clazz.cast(this.regionMap()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationSet, T> g) {
        return obj -> g.apply((ReplicationSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String createdBy;
        private Instant createdTime;
        private Boolean deletionProtected;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private Map<String, RegionInfo> regionMap = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationSet model) {
            this.arn(model.arn);
            this.createdBy(model.createdBy);
            this.createdTime(model.createdTime);
            this.deletionProtected(model.deletionProtected);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.regionMap(model.regionMap);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getDeletionProtected() {
            return this.deletionProtected;
        }

        public final void setDeletionProtected(Boolean deletionProtected) {
            this.deletionProtected = deletionProtected;
        }

        @Override
        public final Builder deletionProtected(Boolean deletionProtected) {
            this.deletionProtected = deletionProtected;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, RegionInfo.Builder> getRegionMap() {
            Map<String, RegionInfo.Builder> result = RegionInfoMapCopier.copyToBuilder(this.regionMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRegionMap(Map<String, RegionInfo.BuilderImpl> regionMap) {
            this.regionMap = RegionInfoMapCopier.copyFromBuilder(regionMap);
        }

        @Override
        public final Builder regionMap(Map<String, RegionInfo> regionMap) {
            this.regionMap = RegionInfoMapCopier.copy(regionMap);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplicationSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ReplicationSet build() {
            return new ReplicationSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationSet> {
        public Builder arn(String var1);

        public Builder createdBy(String var1);

        public Builder createdTime(Instant var1);

        public Builder deletionProtected(Boolean var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder regionMap(Map<String, RegionInfo> var1);

        public Builder status(String var1);

        public Builder status(ReplicationSetStatus var1);
    }
}

