/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VariableType {
    INCIDENT_RECORD_ARN("INCIDENT_RECORD_ARN"),
    INVOLVED_RESOURCES("INVOLVED_RESOURCES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VariableType> VALUE_MAP;
    private final String value;

    private VariableType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VariableType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VariableType> knownValues() {
        EnumSet<VariableType> knownValues = EnumSet.allOf(VariableType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VariableType.class, VariableType::toString);
    }
}

