/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheAttributes;
import software.amazon.awssdk.services.storagegateway.model.EncryptionType;
import software.amazon.awssdk.services.storagegateway.model.FileShareClientListCopier;
import software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults;
import software.amazon.awssdk.services.storagegateway.model.ObjectACL;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNfsFileShareRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateNfsFileShareRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::fileShareARN)).setter(UpdateNfsFileShareRequest.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::encryptionTypeAsString)).setter(UpdateNfsFileShareRequest.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KMSEncrypted").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::kmsEncrypted)).setter(UpdateNfsFileShareRequest.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKey").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::kmsKey)).setter(UpdateNfsFileShareRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<NFSFileShareDefaults> NFS_FILE_SHARE_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NFSFileShareDefaults").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::nfsFileShareDefaults)).setter(UpdateNfsFileShareRequest.setter(Builder::nfsFileShareDefaults)).constructor(NFSFileShareDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareDefaults").build()}).build();
    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultStorageClass").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::defaultStorageClass)).setter(UpdateNfsFileShareRequest.setter(Builder::defaultStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build()}).build();
    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectACL").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::objectACLAsString)).setter(UpdateNfsFileShareRequest.setter(Builder::objectACL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()}).build();
    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientList").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::clientList)).setter(UpdateNfsFileShareRequest.setter(Builder::clientList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SQUASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Squash").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::squash)).setter(UpdateNfsFileShareRequest.setter(Builder::squash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Squash").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadOnly").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::readOnly)).setter(UpdateNfsFileShareRequest.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GuessMIMETypeEnabled").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::guessMIMETypeEnabled)).setter(UpdateNfsFileShareRequest.setter(Builder::guessMIMETypeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterPays").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::requesterPays)).setter(UpdateNfsFileShareRequest.setter(Builder::requesterPays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()}).build();
    private static final SdkField<String> FILE_SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareName").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::fileShareName)).setter(UpdateNfsFileShareRequest.setter(Builder::fileShareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareName").build()}).build();
    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheAttributes").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::cacheAttributes)).setter(UpdateNfsFileShareRequest.setter(Builder::cacheAttributes)).constructor(CacheAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()}).build();
    private static final SdkField<String> NOTIFICATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationPolicy").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::notificationPolicy)).setter(UpdateNfsFileShareRequest.setter(Builder::notificationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationPolicy").build()}).build();
    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditDestinationARN").getter(UpdateNfsFileShareRequest.getter(UpdateNfsFileShareRequest::auditDestinationARN)).setter(UpdateNfsFileShareRequest.setter(Builder::auditDestinationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD, ENCRYPTION_TYPE_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, NFS_FILE_SHARE_DEFAULTS_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, CLIENT_LIST_FIELD, SQUASH_FIELD, READ_ONLY_FIELD, GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, FILE_SHARE_NAME_FIELD, CACHE_ATTRIBUTES_FIELD, NOTIFICATION_POLICY_FIELD, AUDIT_DESTINATION_ARN_FIELD));
    private final String fileShareARN;
    private final String encryptionType;
    private final Boolean kmsEncrypted;
    private final String kmsKey;
    private final NFSFileShareDefaults nfsFileShareDefaults;
    private final String defaultStorageClass;
    private final String objectACL;
    private final List<String> clientList;
    private final String squash;
    private final Boolean readOnly;
    private final Boolean guessMIMETypeEnabled;
    private final Boolean requesterPays;
    private final String fileShareName;
    private final CacheAttributes cacheAttributes;
    private final String notificationPolicy;
    private final String auditDestinationARN;

    private UpdateNfsFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.encryptionType = builder.encryptionType;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.nfsFileShareDefaults = builder.nfsFileShareDefaults;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.clientList = builder.clientList;
        this.squash = builder.squash;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.fileShareName = builder.fileShareName;
        this.cacheAttributes = builder.cacheAttributes;
        this.notificationPolicy = builder.notificationPolicy;
        this.auditDestinationARN = builder.auditDestinationARN;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    @Deprecated
    public final Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final NFSFileShareDefaults nfsFileShareDefaults() {
        return this.nfsFileShareDefaults;
    }

    public final String defaultStorageClass() {
        return this.defaultStorageClass;
    }

    public final ObjectACL objectACL() {
        return ObjectACL.fromValue(this.objectACL);
    }

    public final String objectACLAsString() {
        return this.objectACL;
    }

    public final boolean hasClientList() {
        return this.clientList != null && !(this.clientList instanceof SdkAutoConstructList);
    }

    public final List<String> clientList() {
        return this.clientList;
    }

    public final String squash() {
        return this.squash;
    }

    public final Boolean readOnly() {
        return this.readOnly;
    }

    public final Boolean guessMIMETypeEnabled() {
        return this.guessMIMETypeEnabled;
    }

    public final Boolean requesterPays() {
        return this.requesterPays;
    }

    public final String fileShareName() {
        return this.fileShareName;
    }

    public final CacheAttributes cacheAttributes() {
        return this.cacheAttributes;
    }

    public final String notificationPolicy() {
        return this.notificationPolicy;
    }

    public final String auditDestinationARN() {
        return this.auditDestinationARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsFileShareDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientList() ? this.clientList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.squash());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDestinationARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNfsFileShareRequest)) {
            return false;
        }
        UpdateNfsFileShareRequest other = (UpdateNfsFileShareRequest)((Object)obj);
        return Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.nfsFileShareDefaults(), other.nfsFileShareDefaults()) && Objects.equals(this.defaultStorageClass(), other.defaultStorageClass()) && Objects.equals(this.objectACLAsString(), other.objectACLAsString()) && this.hasClientList() == other.hasClientList() && Objects.equals(this.clientList(), other.clientList()) && Objects.equals(this.squash(), other.squash()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.guessMIMETypeEnabled(), other.guessMIMETypeEnabled()) && Objects.equals(this.requesterPays(), other.requesterPays()) && Objects.equals(this.fileShareName(), other.fileShareName()) && Objects.equals(this.cacheAttributes(), other.cacheAttributes()) && Objects.equals(this.notificationPolicy(), other.notificationPolicy()) && Objects.equals(this.auditDestinationARN(), other.auditDestinationARN());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNfsFileShareRequest").add("FileShareARN", (Object)this.fileShareARN()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).add("NFSFileShareDefaults", (Object)this.nfsFileShareDefaults()).add("DefaultStorageClass", (Object)this.defaultStorageClass()).add("ObjectACL", (Object)this.objectACLAsString()).add("ClientList", this.hasClientList() ? this.clientList() : null).add("Squash", (Object)this.squash()).add("ReadOnly", (Object)this.readOnly()).add("GuessMIMETypeEnabled", (Object)this.guessMIMETypeEnabled()).add("RequesterPays", (Object)this.requesterPays()).add("FileShareName", (Object)this.fileShareName()).add("CacheAttributes", (Object)this.cacheAttributes()).add("NotificationPolicy", (Object)this.notificationPolicy()).add("AuditDestinationARN", (Object)this.auditDestinationARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "NFSFileShareDefaults": {
                return Optional.ofNullable(clazz.cast(this.nfsFileShareDefaults()));
            }
            case "DefaultStorageClass": {
                return Optional.ofNullable(clazz.cast(this.defaultStorageClass()));
            }
            case "ObjectACL": {
                return Optional.ofNullable(clazz.cast(this.objectACLAsString()));
            }
            case "ClientList": {
                return Optional.ofNullable(clazz.cast(this.clientList()));
            }
            case "Squash": {
                return Optional.ofNullable(clazz.cast(this.squash()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "GuessMIMETypeEnabled": {
                return Optional.ofNullable(clazz.cast(this.guessMIMETypeEnabled()));
            }
            case "RequesterPays": {
                return Optional.ofNullable(clazz.cast(this.requesterPays()));
            }
            case "FileShareName": {
                return Optional.ofNullable(clazz.cast(this.fileShareName()));
            }
            case "CacheAttributes": {
                return Optional.ofNullable(clazz.cast(this.cacheAttributes()));
            }
            case "NotificationPolicy": {
                return Optional.ofNullable(clazz.cast(this.notificationPolicy()));
            }
            case "AuditDestinationARN": {
                return Optional.ofNullable(clazz.cast(this.auditDestinationARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNfsFileShareRequest, T> g) {
        return obj -> g.apply((UpdateNfsFileShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String fileShareARN;
        private String encryptionType;
        private Boolean kmsEncrypted;
        private String kmsKey;
        private NFSFileShareDefaults nfsFileShareDefaults;
        private String defaultStorageClass;
        private String objectACL;
        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();
        private String squash;
        private Boolean readOnly;
        private Boolean guessMIMETypeEnabled;
        private Boolean requesterPays;
        private String fileShareName;
        private CacheAttributes cacheAttributes;
        private String notificationPolicy;
        private String auditDestinationARN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNfsFileShareRequest model) {
            super(model);
            this.fileShareARN(model.fileShareARN);
            this.encryptionType(model.encryptionType);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
            this.nfsFileShareDefaults(model.nfsFileShareDefaults);
            this.defaultStorageClass(model.defaultStorageClass);
            this.objectACL(model.objectACL);
            this.clientList(model.clientList);
            this.squash(model.squash);
            this.readOnly(model.readOnly);
            this.guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            this.requesterPays(model.requesterPays);
            this.fileShareName(model.fileShareName);
            this.cacheAttributes(model.cacheAttributes);
            this.notificationPolicy(model.notificationPolicy);
            this.auditDestinationARN(model.auditDestinationARN);
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Deprecated
        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        @Deprecated
        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        @Deprecated
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final NFSFileShareDefaults.Builder getNfsFileShareDefaults() {
            return this.nfsFileShareDefaults != null ? this.nfsFileShareDefaults.toBuilder() : null;
        }

        public final void setNfsFileShareDefaults(NFSFileShareDefaults.BuilderImpl nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults != null ? nfsFileShareDefaults.build() : null;
        }

        @Override
        public final Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults;
            return this;
        }

        public final String getDefaultStorageClass() {
            return this.defaultStorageClass;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final String getObjectACL() {
            return this.objectACL;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final Collection<String> getClientList() {
            if (this.clientList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientList;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String ... clientList) {
            this.clientList(Arrays.asList(clientList));
            return this;
        }

        public final String getSquash() {
            return this.squash;
        }

        public final void setSquash(String squash) {
            this.squash = squash;
        }

        @Override
        public final Builder squash(String squash) {
            this.squash = squash;
            return this;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return this.guessMIMETypeEnabled;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final Boolean getRequesterPays() {
            return this.requesterPays;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final String getFileShareName() {
            return this.fileShareName;
        }

        public final void setFileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
        }

        @Override
        public final Builder fileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return this.cacheAttributes != null ? this.cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final String getNotificationPolicy() {
            return this.notificationPolicy;
        }

        public final void setNotificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
        }

        @Override
        public final Builder notificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            return this;
        }

        public final String getAuditDestinationARN() {
            return this.auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNfsFileShareRequest build() {
            return new UpdateNfsFileShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNfsFileShareRequest> {
        public Builder fileShareARN(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        @Deprecated
        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder nfsFileShareDefaults(NFSFileShareDefaults var1);

        default public Builder nfsFileShareDefaults(Consumer<NFSFileShareDefaults.Builder> nfsFileShareDefaults) {
            return this.nfsFileShareDefaults((NFSFileShareDefaults)((NFSFileShareDefaults.Builder)NFSFileShareDefaults.builder().applyMutation(nfsFileShareDefaults)).build());
        }

        public Builder defaultStorageClass(String var1);

        public Builder objectACL(String var1);

        public Builder objectACL(ObjectACL var1);

        public Builder clientList(Collection<String> var1);

        public Builder clientList(String ... var1);

        public Builder squash(String var1);

        public Builder readOnly(Boolean var1);

        public Builder guessMIMETypeEnabled(Boolean var1);

        public Builder requesterPays(Boolean var1);

        public Builder fileShareName(String var1);

        public Builder cacheAttributes(CacheAttributes var1);

        default public Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return this.cacheAttributes((CacheAttributes)((CacheAttributes.Builder)CacheAttributes.builder().applyMutation(cacheAttributes)).build());
        }

        public Builder notificationPolicy(String var1);

        public Builder auditDestinationARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

