/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.FileShareInfo;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse;

public class ListFileSharesIterable
implements SdkIterable<ListFileSharesResponse> {
    private final StorageGatewayClient client;
    private final ListFileSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFileSharesIterable(StorageGatewayClient client, ListFileSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFileSharesResponseFetcher();
    }

    public Iterator<ListFileSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FileShareInfo> fileShareInfoList() {
        Function<ListFileSharesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fileShareInfoList() != null) {
                return response.fileShareInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFileSharesResponseFetcher
    implements SyncPageFetcher<ListFileSharesResponse> {
        private ListFileSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListFileSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListFileSharesResponse nextPage(ListFileSharesResponse previousPage) {
            if (previousPage == null) {
                return ListFileSharesIterable.this.client.listFileShares(ListFileSharesIterable.this.firstRequest);
            }
            return ListFileSharesIterable.this.client.listFileShares((ListFileSharesRequest)((Object)ListFileSharesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

