/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.ListTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeInfo;

public class ListTapesPublisher
implements SdkPublisher<ListTapesResponse> {
    private final StorageGatewayAsyncClient client;
    private final ListTapesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTapesPublisher(StorageGatewayAsyncClient client, ListTapesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTapesPublisher(StorageGatewayAsyncClient client, ListTapesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTapesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTapesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TapeInfo> tapeInfos() {
        Function<ListTapesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapeInfos() != null) {
                return response.tapeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTapesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTapesResponseFetcher
    implements AsyncPageFetcher<ListTapesResponse> {
        private ListTapesResponseFetcher() {
        }

        public boolean hasNextPage(ListTapesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListTapesResponse> nextPage(ListTapesResponse previousPage) {
            if (previousPage == null) {
                return ListTapesPublisher.this.client.listTapes(ListTapesPublisher.this.firstRequest);
            }
            return ListTapesPublisher.this.client.listTapes((ListTapesRequest)((Object)ListTapesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

