/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.ParallelDataStatus;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateParallelDataResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, UpdateParallelDataResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateParallelDataResponse.getter(UpdateParallelDataResponse::name)).setter(UpdateParallelDataResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateParallelDataResponse.getter(UpdateParallelDataResponse::statusAsString)).setter(UpdateParallelDataResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> LATEST_UPDATE_ATTEMPT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestUpdateAttemptStatus").getter(UpdateParallelDataResponse.getter(UpdateParallelDataResponse::latestUpdateAttemptStatusAsString)).setter(UpdateParallelDataResponse.setter(Builder::latestUpdateAttemptStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUpdateAttemptStatus").build()}).build();
    private static final SdkField<Instant> LATEST_UPDATE_ATTEMPT_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestUpdateAttemptAt").getter(UpdateParallelDataResponse.getter(UpdateParallelDataResponse::latestUpdateAttemptAt)).setter(UpdateParallelDataResponse.setter(Builder::latestUpdateAttemptAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUpdateAttemptAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, LATEST_UPDATE_ATTEMPT_STATUS_FIELD, LATEST_UPDATE_ATTEMPT_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("LatestUpdateAttemptStatus", LATEST_UPDATE_ATTEMPT_STATUS_FIELD);
            this.put("LatestUpdateAttemptAt", LATEST_UPDATE_ATTEMPT_AT_FIELD);
        }
    });
    private final String name;
    private final String status;
    private final String latestUpdateAttemptStatus;
    private final Instant latestUpdateAttemptAt;

    private UpdateParallelDataResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.status = builder.status;
        this.latestUpdateAttemptStatus = builder.latestUpdateAttemptStatus;
        this.latestUpdateAttemptAt = builder.latestUpdateAttemptAt;
    }

    public final String name() {
        return this.name;
    }

    public final ParallelDataStatus status() {
        return ParallelDataStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ParallelDataStatus latestUpdateAttemptStatus() {
        return ParallelDataStatus.fromValue(this.latestUpdateAttemptStatus);
    }

    public final String latestUpdateAttemptStatusAsString() {
        return this.latestUpdateAttemptStatus;
    }

    public final Instant latestUpdateAttemptAt() {
        return this.latestUpdateAttemptAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUpdateAttemptStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUpdateAttemptAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParallelDataResponse)) {
            return false;
        }
        UpdateParallelDataResponse other = (UpdateParallelDataResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.latestUpdateAttemptStatusAsString(), other.latestUpdateAttemptStatusAsString()) && Objects.equals(this.latestUpdateAttemptAt(), other.latestUpdateAttemptAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateParallelDataResponse").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("LatestUpdateAttemptStatus", (Object)this.latestUpdateAttemptStatusAsString()).add("LatestUpdateAttemptAt", (Object)this.latestUpdateAttemptAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LatestUpdateAttemptStatus": {
                return Optional.ofNullable(clazz.cast(this.latestUpdateAttemptStatusAsString()));
            }
            case "LatestUpdateAttemptAt": {
                return Optional.ofNullable(clazz.cast(this.latestUpdateAttemptAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateParallelDataResponse, T> g) {
        return obj -> g.apply((UpdateParallelDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String latestUpdateAttemptStatus;
        private Instant latestUpdateAttemptAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParallelDataResponse model) {
            super(model);
            this.name(model.name);
            this.status(model.status);
            this.latestUpdateAttemptStatus(model.latestUpdateAttemptStatus);
            this.latestUpdateAttemptAt(model.latestUpdateAttemptAt);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ParallelDataStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLatestUpdateAttemptStatus() {
            return this.latestUpdateAttemptStatus;
        }

        public final void setLatestUpdateAttemptStatus(String latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus = latestUpdateAttemptStatus;
        }

        @Override
        public final Builder latestUpdateAttemptStatus(String latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus = latestUpdateAttemptStatus;
            return this;
        }

        @Override
        public final Builder latestUpdateAttemptStatus(ParallelDataStatus latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus(latestUpdateAttemptStatus == null ? null : latestUpdateAttemptStatus.toString());
            return this;
        }

        public final Instant getLatestUpdateAttemptAt() {
            return this.latestUpdateAttemptAt;
        }

        public final void setLatestUpdateAttemptAt(Instant latestUpdateAttemptAt) {
            this.latestUpdateAttemptAt = latestUpdateAttemptAt;
        }

        @Override
        public final Builder latestUpdateAttemptAt(Instant latestUpdateAttemptAt) {
            this.latestUpdateAttemptAt = latestUpdateAttemptAt;
            return this;
        }

        @Override
        public UpdateParallelDataResponse build() {
            return new UpdateParallelDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateParallelDataResponse> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ParallelDataStatus var1);

        public Builder latestUpdateAttemptStatus(String var1);

        public Builder latestUpdateAttemptStatus(ParallelDataStatus var1);

        public Builder latestUpdateAttemptAt(Instant var1);
    }
}

