/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceCreationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceCreationProperties> {
    private static final SdkField<Boolean> ENABLE_WORK_DOCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableWorkDocs").getter(WorkspaceCreationProperties.getter(WorkspaceCreationProperties::enableWorkDocs)).setter(WorkspaceCreationProperties.setter(Builder::enableWorkDocs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableWorkDocs").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableInternetAccess").getter(WorkspaceCreationProperties.getter(WorkspaceCreationProperties::enableInternetAccess)).setter(WorkspaceCreationProperties.setter(Builder::enableInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInternetAccess").build()}).build();
    private static final SdkField<String> DEFAULT_OU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultOu").getter(WorkspaceCreationProperties.getter(WorkspaceCreationProperties::defaultOu)).setter(WorkspaceCreationProperties.setter(Builder::defaultOu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOu").build()}).build();
    private static final SdkField<String> CUSTOM_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomSecurityGroupId").getter(WorkspaceCreationProperties.getter(WorkspaceCreationProperties::customSecurityGroupId)).setter(WorkspaceCreationProperties.setter(Builder::customSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSecurityGroupId").build()}).build();
    private static final SdkField<Boolean> USER_ENABLED_AS_LOCAL_ADMINISTRATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserEnabledAsLocalAdministrator").getter(WorkspaceCreationProperties.getter(WorkspaceCreationProperties::userEnabledAsLocalAdministrator)).setter(WorkspaceCreationProperties.setter(Builder::userEnabledAsLocalAdministrator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserEnabledAsLocalAdministrator").build()}).build();
    private static final SdkField<Boolean> ENABLE_MAINTENANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableMaintenanceMode").getter(WorkspaceCreationProperties.getter(WorkspaceCreationProperties::enableMaintenanceMode)).setter(WorkspaceCreationProperties.setter(Builder::enableMaintenanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMaintenanceMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_WORK_DOCS_FIELD, ENABLE_INTERNET_ACCESS_FIELD, DEFAULT_OU_FIELD, CUSTOM_SECURITY_GROUP_ID_FIELD, USER_ENABLED_AS_LOCAL_ADMINISTRATOR_FIELD, ENABLE_MAINTENANCE_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enableWorkDocs;
    private final Boolean enableInternetAccess;
    private final String defaultOu;
    private final String customSecurityGroupId;
    private final Boolean userEnabledAsLocalAdministrator;
    private final Boolean enableMaintenanceMode;

    private WorkspaceCreationProperties(BuilderImpl builder) {
        this.enableWorkDocs = builder.enableWorkDocs;
        this.enableInternetAccess = builder.enableInternetAccess;
        this.defaultOu = builder.defaultOu;
        this.customSecurityGroupId = builder.customSecurityGroupId;
        this.userEnabledAsLocalAdministrator = builder.userEnabledAsLocalAdministrator;
        this.enableMaintenanceMode = builder.enableMaintenanceMode;
    }

    public final Boolean enableWorkDocs() {
        return this.enableWorkDocs;
    }

    public final Boolean enableInternetAccess() {
        return this.enableInternetAccess;
    }

    public final String defaultOu() {
        return this.defaultOu;
    }

    public final String customSecurityGroupId() {
        return this.customSecurityGroupId;
    }

    public final Boolean userEnabledAsLocalAdministrator() {
        return this.userEnabledAsLocalAdministrator;
    }

    public final Boolean enableMaintenanceMode() {
        return this.enableMaintenanceMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableWorkDocs());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOu());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userEnabledAsLocalAdministrator());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMaintenanceMode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceCreationProperties)) {
            return false;
        }
        WorkspaceCreationProperties other = (WorkspaceCreationProperties)obj;
        return Objects.equals(this.enableWorkDocs(), other.enableWorkDocs()) && Objects.equals(this.enableInternetAccess(), other.enableInternetAccess()) && Objects.equals(this.defaultOu(), other.defaultOu()) && Objects.equals(this.customSecurityGroupId(), other.customSecurityGroupId()) && Objects.equals(this.userEnabledAsLocalAdministrator(), other.userEnabledAsLocalAdministrator()) && Objects.equals(this.enableMaintenanceMode(), other.enableMaintenanceMode());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceCreationProperties").add("EnableWorkDocs", (Object)this.enableWorkDocs()).add("EnableInternetAccess", (Object)this.enableInternetAccess()).add("DefaultOu", (Object)this.defaultOu()).add("CustomSecurityGroupId", (Object)this.customSecurityGroupId()).add("UserEnabledAsLocalAdministrator", (Object)this.userEnabledAsLocalAdministrator()).add("EnableMaintenanceMode", (Object)this.enableMaintenanceMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableWorkDocs": {
                return Optional.ofNullable(clazz.cast(this.enableWorkDocs()));
            }
            case "EnableInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableInternetAccess()));
            }
            case "DefaultOu": {
                return Optional.ofNullable(clazz.cast(this.defaultOu()));
            }
            case "CustomSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.customSecurityGroupId()));
            }
            case "UserEnabledAsLocalAdministrator": {
                return Optional.ofNullable(clazz.cast(this.userEnabledAsLocalAdministrator()));
            }
            case "EnableMaintenanceMode": {
                return Optional.ofNullable(clazz.cast(this.enableMaintenanceMode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceCreationProperties, T> g) {
        return obj -> g.apply((WorkspaceCreationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableWorkDocs;
        private Boolean enableInternetAccess;
        private String defaultOu;
        private String customSecurityGroupId;
        private Boolean userEnabledAsLocalAdministrator;
        private Boolean enableMaintenanceMode;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceCreationProperties model) {
            this.enableWorkDocs(model.enableWorkDocs);
            this.enableInternetAccess(model.enableInternetAccess);
            this.defaultOu(model.defaultOu);
            this.customSecurityGroupId(model.customSecurityGroupId);
            this.userEnabledAsLocalAdministrator(model.userEnabledAsLocalAdministrator);
            this.enableMaintenanceMode(model.enableMaintenanceMode);
        }

        public final Boolean getEnableWorkDocs() {
            return this.enableWorkDocs;
        }

        public final void setEnableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
        }

        @Override
        public final Builder enableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
            return this;
        }

        public final Boolean getEnableInternetAccess() {
            return this.enableInternetAccess;
        }

        public final void setEnableInternetAccess(Boolean enableInternetAccess) {
            this.enableInternetAccess = enableInternetAccess;
        }

        @Override
        public final Builder enableInternetAccess(Boolean enableInternetAccess) {
            this.enableInternetAccess = enableInternetAccess;
            return this;
        }

        public final String getDefaultOu() {
            return this.defaultOu;
        }

        public final void setDefaultOu(String defaultOu) {
            this.defaultOu = defaultOu;
        }

        @Override
        public final Builder defaultOu(String defaultOu) {
            this.defaultOu = defaultOu;
            return this;
        }

        public final String getCustomSecurityGroupId() {
            return this.customSecurityGroupId;
        }

        public final void setCustomSecurityGroupId(String customSecurityGroupId) {
            this.customSecurityGroupId = customSecurityGroupId;
        }

        @Override
        public final Builder customSecurityGroupId(String customSecurityGroupId) {
            this.customSecurityGroupId = customSecurityGroupId;
            return this;
        }

        public final Boolean getUserEnabledAsLocalAdministrator() {
            return this.userEnabledAsLocalAdministrator;
        }

        public final void setUserEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator) {
            this.userEnabledAsLocalAdministrator = userEnabledAsLocalAdministrator;
        }

        @Override
        public final Builder userEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator) {
            this.userEnabledAsLocalAdministrator = userEnabledAsLocalAdministrator;
            return this;
        }

        public final Boolean getEnableMaintenanceMode() {
            return this.enableMaintenanceMode;
        }

        public final void setEnableMaintenanceMode(Boolean enableMaintenanceMode) {
            this.enableMaintenanceMode = enableMaintenanceMode;
        }

        @Override
        public final Builder enableMaintenanceMode(Boolean enableMaintenanceMode) {
            this.enableMaintenanceMode = enableMaintenanceMode;
            return this;
        }

        public WorkspaceCreationProperties build() {
            return new WorkspaceCreationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceCreationProperties> {
        public Builder enableWorkDocs(Boolean var1);

        public Builder enableInternetAccess(Boolean var1);

        public Builder defaultOu(String var1);

        public Builder customSecurityGroupId(String var1);

        public Builder userEnabledAsLocalAdministrator(Boolean var1);

        public Builder enableMaintenanceMode(Boolean var1);
    }
}

