/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.Workspace;

public class DescribeWorkspacesPublisher
implements SdkPublisher<DescribeWorkspacesResponse> {
    private final WorkSpacesAsyncClient client;
    private final DescribeWorkspacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeWorkspacesPublisher(WorkSpacesAsyncClient client, DescribeWorkspacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeWorkspacesPublisher(WorkSpacesAsyncClient client, DescribeWorkspacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeWorkspacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeWorkspacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Workspace> workspaces() {
        Function<DescribeWorkspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaces() != null) {
                return response.workspaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeWorkspacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeWorkspacesResponseFetcher
    implements AsyncPageFetcher<DescribeWorkspacesResponse> {
        private DescribeWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeWorkspacesResponse> nextPage(DescribeWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeWorkspacesPublisher.this.client.describeWorkspaces(DescribeWorkspacesPublisher.this.firstRequest);
            }
            return DescribeWorkspacesPublisher.this.client.describeWorkspaces((DescribeWorkspacesRequest)((Object)DescribeWorkspacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

