/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MicrosoftEntraConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MicrosoftEntraConfig> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(MicrosoftEntraConfig.getter(MicrosoftEntraConfig::tenantId)).setter(MicrosoftEntraConfig.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()}).build();
    private static final SdkField<String> APPLICATION_CONFIG_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationConfigSecretArn").getter(MicrosoftEntraConfig.getter(MicrosoftEntraConfig::applicationConfigSecretArn)).setter(MicrosoftEntraConfig.setter(Builder::applicationConfigSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfigSecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD, APPLICATION_CONFIG_SECRET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tenantId;
    private final String applicationConfigSecretArn;

    private MicrosoftEntraConfig(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.applicationConfigSecretArn = builder.applicationConfigSecretArn;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String applicationConfigSecretArn() {
        return this.applicationConfigSecretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfigSecretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MicrosoftEntraConfig)) {
            return false;
        }
        MicrosoftEntraConfig other = (MicrosoftEntraConfig)obj;
        return Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.applicationConfigSecretArn(), other.applicationConfigSecretArn());
    }

    public final String toString() {
        return ToString.builder((String)"MicrosoftEntraConfig").add("TenantId", (Object)this.tenantId()).add("ApplicationConfigSecretArn", (Object)this.applicationConfigSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "ApplicationConfigSecretArn": {
                return Optional.ofNullable(clazz.cast(this.applicationConfigSecretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MicrosoftEntraConfig, T> g) {
        return obj -> g.apply((MicrosoftEntraConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantId;
        private String applicationConfigSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MicrosoftEntraConfig model) {
            this.tenantId(model.tenantId);
            this.applicationConfigSecretArn(model.applicationConfigSecretArn);
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getApplicationConfigSecretArn() {
            return this.applicationConfigSecretArn;
        }

        public final void setApplicationConfigSecretArn(String applicationConfigSecretArn) {
            this.applicationConfigSecretArn = applicationConfigSecretArn;
        }

        @Override
        public final Builder applicationConfigSecretArn(String applicationConfigSecretArn) {
            this.applicationConfigSecretArn = applicationConfigSecretArn;
            return this;
        }

        public MicrosoftEntraConfig build() {
            return new MicrosoftEntraConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MicrosoftEntraConfig> {
        public Builder tenantId(String var1);

        public Builder applicationConfigSecretArn(String var1);
    }
}

