/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceBundle;

public class DescribeWorkspaceBundlesIterable
implements SdkIterable<DescribeWorkspaceBundlesResponse> {
    private final WorkSpacesClient client;
    private final DescribeWorkspaceBundlesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeWorkspaceBundlesIterable(WorkSpacesClient client, DescribeWorkspaceBundlesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeWorkspaceBundlesResponseFetcher();
    }

    public Iterator<DescribeWorkspaceBundlesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkspaceBundle> bundles() {
        Function<DescribeWorkspaceBundlesResponse, Iterator> getIterator = response -> {
            if (response != null && response.bundles() != null) {
                return response.bundles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeWorkspaceBundlesResponseFetcher
    implements SyncPageFetcher<DescribeWorkspaceBundlesResponse> {
        private DescribeWorkspaceBundlesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWorkspaceBundlesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeWorkspaceBundlesResponse nextPage(DescribeWorkspaceBundlesResponse previousPage) {
            if (previousPage == null) {
                return DescribeWorkspaceBundlesIterable.this.client.describeWorkspaceBundles(DescribeWorkspaceBundlesIterable.this.firstRequest);
            }
            return DescribeWorkspaceBundlesIterable.this.client.describeWorkspaceBundles((DescribeWorkspaceBundlesRequest)((Object)DescribeWorkspaceBundlesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

