/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceCreationProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyWorkspaceCreationPropertiesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ModifyWorkspaceCreationPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ModifyWorkspaceCreationPropertiesRequest.getter(ModifyWorkspaceCreationPropertiesRequest::resourceId)).setter(ModifyWorkspaceCreationPropertiesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<WorkspaceCreationProperties> WORKSPACE_CREATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkspaceCreationProperties").getter(ModifyWorkspaceCreationPropertiesRequest.getter(ModifyWorkspaceCreationPropertiesRequest::workspaceCreationProperties)).setter(ModifyWorkspaceCreationPropertiesRequest.setter(Builder::workspaceCreationProperties)).constructor(WorkspaceCreationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceCreationProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, WORKSPACE_CREATION_PROPERTIES_FIELD));
    private final String resourceId;
    private final WorkspaceCreationProperties workspaceCreationProperties;

    private ModifyWorkspaceCreationPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.workspaceCreationProperties = builder.workspaceCreationProperties;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final WorkspaceCreationProperties workspaceCreationProperties() {
        return this.workspaceCreationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceCreationProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyWorkspaceCreationPropertiesRequest)) {
            return false;
        }
        ModifyWorkspaceCreationPropertiesRequest other = (ModifyWorkspaceCreationPropertiesRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.workspaceCreationProperties(), other.workspaceCreationProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyWorkspaceCreationPropertiesRequest").add("ResourceId", (Object)this.resourceId()).add("WorkspaceCreationProperties", (Object)this.workspaceCreationProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "WorkspaceCreationProperties": {
                return Optional.ofNullable(clazz.cast(this.workspaceCreationProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyWorkspaceCreationPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyWorkspaceCreationPropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private WorkspaceCreationProperties workspaceCreationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyWorkspaceCreationPropertiesRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.workspaceCreationProperties(model.workspaceCreationProperties);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final WorkspaceCreationProperties.Builder getWorkspaceCreationProperties() {
            return this.workspaceCreationProperties != null ? this.workspaceCreationProperties.toBuilder() : null;
        }

        public final void setWorkspaceCreationProperties(WorkspaceCreationProperties.BuilderImpl workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties != null ? workspaceCreationProperties.build() : null;
        }

        @Override
        public final Builder workspaceCreationProperties(WorkspaceCreationProperties workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyWorkspaceCreationPropertiesRequest build() {
            return new ModifyWorkspaceCreationPropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyWorkspaceCreationPropertiesRequest> {
        public Builder resourceId(String var1);

        public Builder workspaceCreationProperties(WorkspaceCreationProperties var1);

        default public Builder workspaceCreationProperties(Consumer<WorkspaceCreationProperties.Builder> workspaceCreationProperties) {
            return this.workspaceCreationProperties((WorkspaceCreationProperties)((WorkspaceCreationProperties.Builder)WorkspaceCreationProperties.builder().applyMutation(workspaceCreationProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

