/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.AuthenticationType;
import software.amazon.awssdk.services.workspaces.model.NetworkAccessConfiguration;
import software.amazon.awssdk.services.workspaces.model.SessionConnectionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspacesPoolSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspacesPoolSession> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::authenticationTypeAsString)).setter(WorkspacesPoolSession.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionState").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::connectionStateAsString)).setter(WorkspacesPoolSession.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::sessionId)).setter(WorkspacesPoolSession.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::instanceId)).setter(WorkspacesPoolSession.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::poolId)).setter(WorkspacesPoolSession.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::expirationTime)).setter(WorkspacesPoolSession.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()}).build();
    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkAccessConfiguration").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::networkAccessConfiguration)).setter(WorkspacesPoolSession.setter(Builder::networkAccessConfiguration)).constructor(NetworkAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAccessConfiguration").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::startTime)).setter(WorkspacesPoolSession.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(WorkspacesPoolSession.getter(WorkspacesPoolSession::userId)).setter(WorkspacesPoolSession.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, CONNECTION_STATE_FIELD, SESSION_ID_FIELD, INSTANCE_ID_FIELD, POOL_ID_FIELD, EXPIRATION_TIME_FIELD, NETWORK_ACCESS_CONFIGURATION_FIELD, START_TIME_FIELD, USER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final String connectionState;
    private final String sessionId;
    private final String instanceId;
    private final String poolId;
    private final Instant expirationTime;
    private final NetworkAccessConfiguration networkAccessConfiguration;
    private final Instant startTime;
    private final String userId;

    private WorkspacesPoolSession(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.connectionState = builder.connectionState;
        this.sessionId = builder.sessionId;
        this.instanceId = builder.instanceId;
        this.poolId = builder.poolId;
        this.expirationTime = builder.expirationTime;
        this.networkAccessConfiguration = builder.networkAccessConfiguration;
        this.startTime = builder.startTime;
        this.userId = builder.userId;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final SessionConnectionState connectionState() {
        return SessionConnectionState.fromValue(this.connectionState);
    }

    public final String connectionStateAsString() {
        return this.connectionState;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final NetworkAccessConfiguration networkAccessConfiguration() {
        return this.networkAccessConfiguration;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAccessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacesPoolSession)) {
            return false;
        }
        WorkspacesPoolSession other = (WorkspacesPoolSession)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.networkAccessConfiguration(), other.networkAccessConfiguration()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.userId(), other.userId());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspacesPoolSession").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("ConnectionState", (Object)this.connectionStateAsString()).add("SessionId", (Object)this.sessionId()).add("InstanceId", (Object)this.instanceId()).add("PoolId", (Object)this.poolId()).add("ExpirationTime", (Object)this.expirationTime()).add("NetworkAccessConfiguration", (Object)this.networkAccessConfiguration()).add("StartTime", (Object)this.startTime()).add("UserId", (Object)this.userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "NetworkAccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkAccessConfiguration()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspacesPoolSession, T> g) {
        return obj -> g.apply((WorkspacesPoolSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private String connectionState;
        private String sessionId;
        private String instanceId;
        private String poolId;
        private Instant expirationTime;
        private NetworkAccessConfiguration networkAccessConfiguration;
        private Instant startTime;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacesPoolSession model) {
            this.authenticationType(model.authenticationType);
            this.connectionState(model.connectionState);
            this.sessionId(model.sessionId);
            this.instanceId(model.instanceId);
            this.poolId(model.poolId);
            this.expirationTime(model.expirationTime);
            this.networkAccessConfiguration(model.networkAccessConfiguration);
            this.startTime(model.startTime);
            this.userId(model.userId);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(SessionConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessConfiguration() {
            return this.networkAccessConfiguration != null ? this.networkAccessConfiguration.toBuilder() : null;
        }

        public final void setNetworkAccessConfiguration(NetworkAccessConfiguration.BuilderImpl networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration != null ? networkAccessConfiguration.build() : null;
        }

        @Override
        public final Builder networkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public WorkspacesPoolSession build() {
            return new WorkspacesPoolSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspacesPoolSession> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder connectionState(String var1);

        public Builder connectionState(SessionConnectionState var1);

        public Builder sessionId(String var1);

        public Builder instanceId(String var1);

        public Builder poolId(String var1);

        public Builder expirationTime(Instant var1);

        public Builder networkAccessConfiguration(NetworkAccessConfiguration var1);

        default public Builder networkAccessConfiguration(Consumer<NetworkAccessConfiguration.Builder> networkAccessConfiguration) {
            return this.networkAccessConfiguration((NetworkAccessConfiguration)((NetworkAccessConfiguration.Builder)NetworkAccessConfiguration.builder().applyMutation(networkAccessConfiguration)).build());
        }

        public Builder startTime(Instant var1);

        public Builder userId(String var1);
    }
}

