/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient;
import software.amazon.awssdk.services.workspaces.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse;

public class DescribeApplicationsPublisher
implements SdkPublisher<DescribeApplicationsResponse> {
    private final WorkSpacesAsyncClient client;
    private final DescribeApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeApplicationsPublisher(WorkSpacesAsyncClient client, DescribeApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeApplicationsPublisher(WorkSpacesAsyncClient client, DescribeApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeApplicationsResponseFetcher
    implements AsyncPageFetcher<DescribeApplicationsResponse> {
        private DescribeApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeApplicationsResponse> nextPage(DescribeApplicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeApplicationsPublisher.this.client.describeApplications(DescribeApplicationsPublisher.this.firstRequest);
            }
            return DescribeApplicationsPublisher.this.client.describeApplications((DescribeApplicationsRequest)((Object)DescribeApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

