/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            this.logger.debug((Object)"Found thread-bound Session for Hibernate interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug((Object)"Using new Session for Hibernate interceptor");
            if (this.getFlushMode() == 0) {
                session.setFlushMode(FlushMode.NEVER);
            }
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)new SessionHolder(session)));
        }
        try {
            this.enableFilters(session);
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(session, existingTransaction);
            Object object = retVal;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        finally {
            this.disableFilters(session);
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }
}

