/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.client;

import com.amazonservices.mws.client.MwsCall;
import com.amazonservices.mws.client.MwsConnection;
import com.amazonservices.mws.client.MwsException;
import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsReader;
import com.amazonservices.mws.client.MwsResponse;
import com.amazonservices.mws.client.MwsResponseHeaderMetadata;
import com.amazonservices.mws.client.MwsUtl;
import com.amazonservices.mws.client.MwsXmlReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Element;

class MwsAQCall
implements MwsCall {
    private final MwsConnection connection;
    private final String operationName;
    private final Map<String, String> parameters = new TreeMap<String, String>();
    private final MwsConnection.ServiceEndpoint serviceEndpoint;
    private MwsResponseHeaderMetadata rhmd;
    private StringBuilder parameterPrefix = new StringBuilder();

    private void addRequiredParametersToRequest(HttpPost request) {
        this.parameters.put("Action", this.operationName);
        this.parameters.put("Version", this.serviceEndpoint.version);
        this.parameters.put("Timestamp", MwsUtl.getFormattedTimestamp());
        this.parameters.put("AWSAccessKeyId", this.connection.getAwsAccessKeyId());
        String signature = MwsUtl.signParameters(this.serviceEndpoint.uri, this.connection.getSignatureVersion(), this.connection.getSignatureMethod(), this.parameters, this.connection.getAwsSecretKeyId());
        this.parameters.put("Signature", signature);
        ArrayList<BasicNameValuePair> parameterList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || key.equals("") || value == null || value.equals("")) continue;
            parameterList.add(new BasicNameValuePair(key, value));
        }
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(parameterList, "UTF-8"));
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    private String getResponseBody(HttpResponse postResponse) {
        InputStream input = null;
        try {
            int len;
            input = postResponse.getEntity().getContent();
            InputStreamReader reader = new InputStreamReader(input, "UTF-8");
            StringBuilder b = new StringBuilder();
            char[] c = new char[1024];
            while (0 < (len = reader.read(c))) {
                b.append(c, 0, len);
            }
            String string = b.toString();
            return string;
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
        finally {
            MwsUtl.close(input);
        }
    }

    private MwsResponseHeaderMetadata getResponseHeaderMetadata(HttpResponse response) {
        Date quotaResetDate;
        Double quotaRemaining;
        Double quotaMax;
        Header requestIdHeader = response.getFirstHeader("x-mws-request-id");
        String requestId = requestIdHeader == null ? null : requestIdHeader.getValue();
        Header timestampHeader = response.getFirstHeader("x-mws-timestamp");
        String timestamp = timestampHeader == null ? null : timestampHeader.getValue();
        Header contextHeader = response.getFirstHeader("x-mws-response-context");
        String contextString = contextHeader == null ? "" : contextHeader.getValue();
        List<String> context = Collections.unmodifiableList(Arrays.asList(contextString.split(",")));
        try {
            Header quotaMaxHeader = response.getFirstHeader("x-mws-quota-max");
            quotaMax = quotaMaxHeader == null ? null : Double.valueOf(quotaMaxHeader.getValue());
        }
        catch (NumberFormatException ex) {
            quotaMax = null;
        }
        try {
            Header quotaRemainingHeader = response.getFirstHeader("x-mws-quota-remaining");
            quotaRemaining = quotaRemainingHeader == null ? null : Double.valueOf(quotaRemainingHeader.getValue());
        }
        catch (NumberFormatException ex) {
            quotaRemaining = null;
        }
        try {
            Header quotaResetHeader = response.getFirstHeader("x-mws-quota-resetsOn");
            quotaResetDate = quotaResetHeader == null ? null : MwsUtl.parseTimestamp(quotaResetHeader.getValue());
        }
        catch (ParseException ex) {
            quotaResetDate = null;
        }
        return new MwsResponseHeaderMetadata(requestId, context, timestamp, quotaMax, quotaRemaining, quotaResetDate);
    }

    private boolean pauseIfRetryNeeded(int retries) {
        if (retries >= this.connection.getMaxErrorRetry()) {
            return false;
        }
        long delay = (long)(Math.random() * Math.pow(4.0, retries) * 125.0);
        try {
            Thread.sleep(delay);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
        return true;
    }

    @Override
    public void beginObject(String name) {
        this.parameterPrefix.append(name);
        this.parameterPrefix.append('.');
    }

    @Override
    public void close() {
    }

    @Override
    public void endObject(String name) {
        int nlen = name.length();
        int pplen = this.parameterPrefix.length();
        if (pplen < nlen + 1 || this.parameterPrefix.charAt(pplen - 1) != '.' || !this.parameterPrefix.subSequence(pplen - nlen - 1, pplen - 1).equals(name)) {
            throw new IllegalStateException();
        }
        this.parameterPrefix.setLength(pplen - nlen - 1);
    }

    @Override
    public MwsResponseHeaderMetadata getResponseHeaderMetadata() {
        return this.rhmd;
    }

    private HttpPost createRequest() {
        HttpPost request = new HttpPost(this.serviceEndpoint.uri);
        try {
            request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            request.addHeader("X-Amazon-User-Agent", this.connection.getUserAgent());
            for (Map.Entry<String, String> header : this.connection.getRequestHeaders().entrySet()) {
                request.addHeader(header.getKey(), header.getValue());
            }
            this.addRequiredParametersToRequest(request);
        }
        catch (Exception e) {
            request.releaseConnection();
            throw MwsUtl.wrap(e);
        }
        return request;
    }

    private HttpResponse executeRequest(HttpPost request) throws Exception {
        try {
            HttpClient httpClient = this.connection.getHttpClient();
            HttpContext httpContext = this.connection.getHttpContext();
            HttpResponse response = httpClient.execute((HttpUriRequest)request, httpContext);
            return response;
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    @Override
    public MwsResponse execute() {
        HttpPost request = this.createRequest();
        try {
            MwsResponse response;
            HttpResponse hr = this.executeRequest(request);
            StatusLine statusLine = hr.getStatusLine();
            int status = statusLine.getStatusCode();
            String message = statusLine.getReasonPhrase();
            this.rhmd = this.getResponseHeaderMetadata(hr);
            String body = this.getResponseBody(hr);
            MwsResponse mwsResponse = response = new MwsResponse(status, message, this.rhmd, body);
            return mwsResponse;
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public MwsReader invoke() {
        HttpPost request = this.createRequest();
        int retryCount = 0;
        while (true) {
            block9: {
                try {
                    HttpResponse response = this.executeRequest(request);
                    StatusLine statusLine = response.getStatusLine();
                    int status = statusLine.getStatusCode();
                    String message = statusLine.getReasonPhrase();
                    this.rhmd = this.getResponseHeaderMetadata(response);
                    String body = this.getResponseBody(response);
                    if (status == 200) {
                        MwsXmlReader mwsXmlReader = new MwsXmlReader(body);
                        return mwsXmlReader;
                    }
                    if (status == 500 && this.pauseIfRetryNeeded(retryCount)) break block9;
                    try {
                        throw new MwsException(status, message, null, null, body, this.rhmd);
                    }
                    catch (Exception e) {
                        throw MwsUtl.wrap(e);
                    }
                }
                finally {
                    request.releaseConnection();
                }
            }
            ++retryCount;
        }
    }

    private void putValue(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof MwsObject) {
            this.parameterPrefix.append('.');
            ((MwsObject)value).writeFragmentTo(this);
            return;
        }
        String svalue = value.toString();
        if (svalue != null && svalue.length() > 0) {
            String name = this.parameterPrefix.toString();
            this.parameters.put(name, svalue);
        }
    }

    @Override
    public void write(String name, Object value) {
        int holdParameterPrefixLen = this.parameterPrefix.length();
        this.parameterPrefix.append(name);
        this.putValue(value);
        this.parameterPrefix.setLength(holdParameterPrefixLen);
    }

    @Override
    public void write(String namespace, String name, MwsObject value) {
        value.writeFragmentTo(this);
    }

    @Override
    public void writeAttribute(String name, Object value) {
        this.write(name, value);
    }

    @Override
    public void writeList(String name, String memberName, Collection<?> list) {
        if (name == null && memberName == null) {
            throw new RuntimeException("Both name and memberName cannot be null.");
        }
        if (list == null) {
            return;
        }
        int holdParameterPrefixLen = this.parameterPrefix.length();
        if (name != null) {
            this.parameterPrefix.append(name);
        }
        if (name != null && memberName != null) {
            this.parameterPrefix.append('.');
        }
        if (memberName != null) {
            this.parameterPrefix.append(memberName);
        }
        this.parameterPrefix.append('.');
        int dotLen = this.parameterPrefix.length();
        int i = 1;
        for (Object value : list) {
            this.parameterPrefix.setLength(dotLen);
            this.parameterPrefix.append(i);
            this.putValue(value);
            ++i;
        }
        this.parameterPrefix.setLength(holdParameterPrefixLen);
    }

    @Override
    public void writeList(String name, Collection<?> list) {
        this.writeList(null, name, list);
    }

    @Override
    public void writeAny(Collection<Element> elements) {
        throw new RuntimeException("writeAny not supported.");
    }

    @Override
    public void writeValue(Object value) {
        throw new RuntimeException("writeValue not supported.");
    }

    MwsAQCall(MwsConnection connection, MwsConnection.ServiceEndpoint serviceEndpoint, String operationName) {
        this.connection = connection;
        this.serviceEndpoint = serviceEndpoint;
        this.operationName = operationName;
    }
}

