/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.ejb.cmp3;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import oracle.toplink.essentials.config.TopLinkProperties;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;
import oracle.toplink.essentials.exceptions.PersistenceUnitLoadingException;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerFactoryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.JavaSECMPInitializer;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.threetier.ServerSession;
import oracle.toplink.essentials.tools.schemaframework.SchemaManager;

public class EntityManagerFactoryProvider
implements PersistenceProvider {
    public static final String TOPLINK_ORM_THROW_EXCEPTIONS = "toplink.orm.throw.exceptions";
    public static final String TOPLINK_VALIDATION_ONLY_PROPERTY = "toplink.validation-only";
    public static final String DDL_GENERATION = "toplink.ddl-generation";
    public static final String CREATE_ONLY = "create-tables";
    public static final String DROP_AND_CREATE = "drop-and-create-tables";
    public static final String NONE = "none";
    public static final String APP_LOCATION = "toplink.application-location";
    public static final String CREATE_JDBC_DDL_FILE = "toplink.create-ddl-jdbc-file-name";
    public static final String DROP_JDBC_DDL_FILE = "toplink.drop-ddl-jdbc-file-name";
    public static final String DEFAULT_APP_LOCATION = "." + File.separator;
    public static final String DEFAULT_CREATE_JDBC_FILE_NAME = "createDDL.jdbc";
    public static final String DEFAULT_DROP_JDBC_FILE_NAME = "dropDDL.jdbc";
    public static final String JAVASE_DB_INTERACTION = "INTERACT_WITH_DB";
    public static final String DDL_GENERATION_MODE = "toplink.ddl-generation.output-mode";
    public static final String DDL_SQL_SCRIPT_GENERATION = "sql-script";
    public static final String DDL_DATABASE_GENERATION = "database";
    public static final String DDL_BOTH_GENERATION = "both";
    public static final String DEFAULT_DDL_GENERATION_MODE = "sql-script";
    protected static HashMap<String, EntityManagerSetupImpl> emSetupImpls = new HashMap();
    protected static final String[][] oldPropertyNames = new String[][]{{"toplink.jdbc.write-connections.max", "toplink.max-write-connections"}, {"toplink.jdbc.write-connections.min", "toplink.min-write-connections"}, {"toplink.jdbc.read-connections.max", "toplink.max-read-connections"}, {"toplink.jdbc.read-connections.min", "toplink.min-read-connections"}, {"toplink.jdbc.bind-parameters", "toplink.bind-all-parameters"}, {"toplink.target-database", "toplink.platform.class.name"}, {"toplink.target-server", "toplink.server.platform.class.name"}, {"toplink.cache.size.default", "toplink.cache.default-size"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        Map nonNullProperties = properties == null ? new HashMap() : properties;
        String name = emName;
        if (name == null) {
            name = "";
        }
        JavaSECMPInitializer initializer = JavaSECMPInitializer.getJavaSECMPInitializer();
        EntityManagerSetupImpl emSetupImpl = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = currentLoader.getResources("META-INF/persistence.xml");
            boolean initialized = false;
            while (resources.hasMoreElements()) {
                URL url = PersistenceUnitProcessor.computePURootURL(resources.nextElement());
                String urlAndName = url + name;
                HashMap<String, EntityManagerSetupImpl> hashMap = emSetupImpls;
                synchronized (hashMap) {
                    emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(urlAndName);
                    if (emSetupImpl == null || emSetupImpl.isUndeployed()) {
                        if (!initialized) {
                            initializer.initialize(nonNullProperties);
                            initialized = true;
                        }
                        emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(urlAndName);
                    }
                }
                if (emSetupImpl == null) continue;
                break;
            }
        }
        catch (Exception e) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(currentLoader, e);
        }
        if (emSetupImpl == null) {
            return null;
        }
        EntityManagerSetupImpl e = emSetupImpl;
        synchronized (e) {
            if (emSetupImpl.shouldRedeploy()) {
                SEPersistenceUnitInfo persistenceInfo = (SEPersistenceUnitInfo)emSetupImpl.getPersistenceUnitInfo();
                persistenceInfo.setClassLoader(JavaSECMPInitializer.getMainLoader());
                persistenceInfo.setNewTempClassLoader(JavaSECMPInitializer.getMainLoader());
            }
            emSetupImpl.predeploy(emSetupImpl.getPersistenceUnitInfo(), nonNullProperties);
        }
        EntityManagerFactoryImpl factory = null;
        try {
            factory = new EntityManagerFactoryImpl(emSetupImpl, nonNullProperties);
            if (emSetupImpl.shouldGetSessionOnCreateFactory(nonNullProperties)) {
                factory.getServerSession();
            }
            return factory;
        }
        catch (RuntimeException ex) {
            if (factory != null) {
                factory.close();
            } else {
                emSetupImpl.undeploy();
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        Map nonNullProperties = properties == null ? new HashMap() : properties;
        EntityManagerSetupImpl emSetupImpl = null;
        HashMap<String, EntityManagerSetupImpl> hashMap = emSetupImpls;
        synchronized (hashMap) {
            String urlAndName = info.getPersistenceUnitRootUrl() + info.getPersistenceUnitName();
            emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(urlAndName);
            if (emSetupImpl == null) {
                emSetupImpl = new EntityManagerSetupImpl();
                emSetupImpl.setIsInContainerMode(true);
                EntityManagerFactoryProvider.addEntityManagerSetupImpl(urlAndName, emSetupImpl);
            }
        }
        ClassTransformer transformer = null;
        if (!emSetupImpl.isDeployed()) {
            transformer = emSetupImpl.predeploy(info, nonNullProperties);
        }
        if (transformer != null) {
            info.addTransformer(transformer);
        }
        EntityManagerFactoryImpl factory = new EntityManagerFactoryImpl(emSetupImpl, nonNullProperties);
        if (emSetupImpl.shouldGetSessionOnCreateFactory(nonNullProperties)) {
            factory.getServerSession();
        }
        return factory;
    }

    public static void login(ServerSession session, Map properties) {
        String toplinkPlatform = (String)properties.get("toplink.target-database");
        if (!session.isConnected()) {
            if (toplinkPlatform == null || toplinkPlatform.equals("Auto")) {
                session.loginAndDetectDatasource();
            } else {
                session.login();
            }
        }
    }

    public static void generateDDLFiles(ServerSession session, Map props, boolean inSEmode) {
        boolean createTables = false;
        boolean shouldDropFirst = false;
        String ddlGeneration = NONE;
        if (null == props) {
            return;
        }
        ddlGeneration = EntityManagerFactoryProvider.getConfigPropertyAsString(DDL_GENERATION, props, NONE);
        if ((ddlGeneration = ddlGeneration.toLowerCase()).equals(NONE)) {
            return;
        }
        if (ddlGeneration.equals(CREATE_ONLY) || ddlGeneration.equals(DROP_AND_CREATE)) {
            createTables = true;
            if (ddlGeneration.equals(DROP_AND_CREATE)) {
                shouldDropFirst = true;
            }
        }
        if (createTables) {
            String ddlGenerationMode = EntityManagerFactoryProvider.getConfigPropertyAsString(DDL_GENERATION_MODE, props, "sql-script");
            if (ddlGenerationMode.equals(NONE)) {
                return;
            }
            String appLocation = EntityManagerFactoryProvider.getConfigPropertyAsString(APP_LOCATION, props, DEFAULT_APP_LOCATION);
            String createDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString(CREATE_JDBC_DDL_FILE, props, DEFAULT_CREATE_JDBC_FILE_NAME);
            String dropDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString(DROP_JDBC_DDL_FILE, props, DEFAULT_DROP_JDBC_FILE_NAME);
            SchemaManager mgr = new SchemaManager(session);
            if (ddlGenerationMode.equals(DDL_DATABASE_GENERATION) || inSEmode) {
                EntityManagerFactoryProvider.runInSEMode(mgr, shouldDropFirst);
                if (inSEmode) {
                    EntityManagerFactoryProvider.writeDDLsToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc);
                }
            } else if (ddlGenerationMode.equals("sql-script")) {
                EntityManagerFactoryProvider.writeDDLsToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc);
            } else if (ddlGenerationMode.equals(DDL_BOTH_GENERATION)) {
                EntityManagerFactoryProvider.runInSEMode(mgr, shouldDropFirst);
                EntityManagerFactoryProvider.writeDDLsToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc);
            }
        }
    }

    public static void runInSEMode(SchemaManager mgr, boolean shouldDropFirst) {
        String str = EntityManagerFactoryProvider.getConfigPropertyAsString(JAVASE_DB_INTERACTION, null, "true");
        boolean interactWithDB = Boolean.valueOf(str.toLowerCase());
        if (!interactWithDB) {
            return;
        }
        EntityManagerFactoryProvider.createOrReplaceDefaultTables(mgr, shouldDropFirst);
    }

    public static String getConfigPropertyAsString(String propertyKey, Map overrides, String defaultValue) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsString(propertyKey, overrides);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getConfigPropertyAsString(String propertyKey, Map overrides) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null) {
            value = System.getProperty(propertyKey);
        }
        return value;
    }

    public static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, String defaultValue, AbstractSession session) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(propertyKey, overrides, session);
        if (value == null) {
            value = defaultValue;
            session.log(1, "properties", "property_value_default", new Object[]{propertyKey, value});
        }
        return value;
    }

    public static String getConfigPropertyAsStringLogDebug(String propertyKey, Map overrides, AbstractSession session) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null) {
            value = System.getProperty(propertyKey);
        }
        if (value != null && session != null) {
            String overrideValue = TopLinkProperties.getOverriddenLogStringForProperty(propertyKey);
            String logValue = overrideValue == null ? value : overrideValue;
            session.log(1, "properties", "property_value_specified", new Object[]{propertyKey, logValue});
        }
        return value;
    }

    public static Object getConfigPropertyLogDebug(String propertyKey, Map overrides, AbstractSession session) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null) {
            value = System.getProperty(propertyKey);
        }
        if (value != null && session != null) {
            String overrideValue = TopLinkProperties.getOverriddenLogStringForProperty(propertyKey);
            String logValue = overrideValue == null ? value : overrideValue;
            session.log(1, "properties", "property_value_specified", new Object[]{propertyKey, logValue});
        }
        return value;
    }

    public static void createOrReplaceDefaultTables(SchemaManager mgr, boolean shouldDropFirst) {
        if (shouldDropFirst) {
            mgr.replaceDefaultTables(true);
        } else {
            mgr.createDefaultTables();
        }
    }

    public static void writeDDLsToFiles(SchemaManager mgr, String appLocation, String createDDLJdbc, String dropDDLJdbc) {
        appLocation = EntityManagerFactoryProvider.addFileSeperator(appLocation);
        if (null != createDDLJdbc) {
            String createJdbcFileName = appLocation + createDDLJdbc;
            mgr.outputCreateDDLToFile(createJdbcFileName);
        }
        if (null != dropDDLJdbc) {
            String dropJdbcFileName = appLocation + dropDDLJdbc;
            mgr.outputDropDDLToFile(dropJdbcFileName);
        }
        mgr.setCreateSQLFiles(false);
        EntityManagerFactoryProvider.createOrReplaceDefaultTables(mgr, true);
        mgr.closeDDLWriter();
    }

    public static String addFileSeperator(String appLocation) {
        int strLength = appLocation.length();
        if (appLocation.substring(strLength - 1, strLength).equals(File.separator)) {
            return appLocation;
        }
        return appLocation + File.separator;
    }

    public static Map mergeMaps(Map target, Map source) {
        HashMap map = new HashMap();
        if (source != null) {
            map.putAll(source);
        }
        if (target != null) {
            map.putAll(target);
        }
        return map;
    }

    public static void translateOldProperties(Map m, AbstractSession session) {
        for (int i = 0; i < oldPropertyNames.length; ++i) {
            String value = EntityManagerFactoryProvider.getConfigPropertyAsString(oldPropertyNames[i][1], m);
            if (value == null) continue;
            if (session != null) {
                session.log(5, "transaction", "deprecated_property", oldPropertyNames[i]);
            }
            m.put(oldPropertyNames[i][0], value);
        }
    }

    public static void warnOldProperties(Map m, AbstractSession session) {
        for (int i = 0; i < oldPropertyNames.length; ++i) {
            Object value = m.get(oldPropertyNames[i][1]);
            if (value == null) continue;
            session.log(5, "transaction", "deprecated_property", oldPropertyNames[i]);
        }
    }

    public static EntityManagerSetupImpl getEntityManagerSetupImpl(String emName) {
        if (emName == null) {
            return emSetupImpls.get("");
        }
        return emSetupImpls.get(emName);
    }

    public static void addEntityManagerSetupImpl(String name, EntityManagerSetupImpl setup) {
        if (name == null) {
            emSetupImpls.put("", setup);
        }
        emSetupImpls.put(name, setup);
    }
}

