/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.NamedObject;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.test.utility.BaseDatabaseTest;

public class CoverageTest
extends BaseDatabaseTest {
    @Test
    public void namedObjectList() {
        NamedObjectList list = new NamedObjectList();
        list.add((NamedObject)new AbstractNamedObject("name1"){
            private static final long serialVersionUID = -514565049545540452L;
        });
        list.add((NamedObject)new AbstractNamedObject("name2"){
            private static final long serialVersionUID = 6176088733525976950L;
        });
        Assert.assertEquals((String)"NamedObjectList size", (long)2L, (long)list.size());
        Assert.assertEquals((String)"NamedObjectList toString", (Object)"name1, name2", (Object)list.toString());
    }

    @Test(expected=NullPointerException.class)
    public void namedObjectListNull() {
        NamedObjectList list = new NamedObjectList();
        list.add(null);
    }

    @Test(expected=SQLException.class)
    public void retrieverConnection() throws SQLException {
        new RetrieverConnection(null, null);
    }

    @Test(expected=SQLException.class)
    public void retrieverConnectionClosed() throws SQLException, SchemaCrawlerException {
        Connection connection = this.getConnection();
        connection.close();
        new RetrieverConnection(connection, null);
    }
}

