/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.google.common.testing.EqualsTester;
import java.io.Serializable;
import org.junit.Test;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.crawl.AbstractProperty;
import schemacrawler.crawl.DatabaseObjectReference;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.TableReference;
import schemacrawler.schema.Property;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Table;

public class EqualsTest {
    @Test
    public void namedObjectEquals() {
        final class TestNamedObject
        extends AbstractNamedObject {
            static final long serialVersionUID = 1L;

            TestNamedObject(String name) {
                super(name);
            }
        }
        TestNamedObject testObject1 = new TestNamedObject("test");
        TestNamedObject testObject2 = new TestNamedObject("test");
        TestNamedObject testObject3 = new TestNamedObject("test 2");
        EqualsTester equalsTester = new EqualsTester().addEqualityGroup(new Object[]{testObject1, testObject2}).addEqualityGroup(new Object[]{testObject3});
        equalsTester.testEquals();
    }

    @Test
    public void namedObjectWithAttributesEquals() {
        final class TestNamedObject
        extends AbstractNamedObjectWithAttributes {
            static final long serialVersionUID = 1L;

            TestNamedObject(String name) {
                super(name);
            }
        }
        TestNamedObject testObject1 = new TestNamedObject("test");
        TestNamedObject testObject2 = new TestNamedObject("test");
        TestNamedObject testObject3 = new TestNamedObject("test 2");
        EqualsTester equalsTester = new EqualsTester().addEqualityGroup(new Object[]{testObject1, testObject2}).addEqualityGroup(new Object[]{testObject3});
        equalsTester.testEquals();
    }

    @Test
    public void privilegeEquals() {
        MutableTable table1 = new MutableTable((Schema)new SchemaReference("catalog", "schema"), "table1");
        MutableTable table2 = new MutableTable((Schema)new SchemaReference("catalog", "schema"), "table2");
        MutablePrivilege testPrivilege1 = new MutablePrivilege((DatabaseObjectReference)new TableReference((Table)table1), "privilegeA");
        MutablePrivilege testPrivilege2 = new MutablePrivilege((DatabaseObjectReference)new TableReference((Table)table1), "privilegeA");
        MutablePrivilege testPrivilege3 = new MutablePrivilege((DatabaseObjectReference)new TableReference((Table)table1), "privilegeB");
        MutablePrivilege testPrivilege4 = new MutablePrivilege((DatabaseObjectReference)new TableReference((Table)table2), "privilegeB");
        EqualsTester equalsTester = new EqualsTester().addEqualityGroup(new Object[]{testPrivilege1, testPrivilege2}).addEqualityGroup(new Object[]{testPrivilege3}).addEqualityGroup(new Object[]{testPrivilege4});
        equalsTester.testEquals();
    }

    @Test
    public void propertyEquals() {
        final class TestProperty
        extends AbstractProperty {
            static final long serialVersionUID = 1L;

            TestProperty(String name, Serializable value) {
                super(name, value);
            }

            public int compareTo(Property o) {
                return 0;
            }

            public String getDescription() {
                return this.getName();
            }
        }
        TestProperty testObject1 = new TestProperty("test", (Serializable)((Object)"value"));
        TestProperty testObject2 = new TestProperty("test", (Serializable)((Object)"value"));
        TestProperty testObject3 = new TestProperty("test 2", (Serializable)((Object)"value 2"));
        EqualsTester equalsTester = new EqualsTester().addEqualityGroup(new Object[]{testObject1, testObject2}).addEqualityGroup(new Object[]{testObject3});
        equalsTester.testEquals();
    }
}

