/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import org.junit.Assert;
import org.junit.Test;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Constraint;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;

public class SchemaCrawlerDeepTest
extends BaseDatabaseTest {
    @Test
    public void tableEquals() throws Exception {
        SchemaReference systemSchema;
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Assert.assertTrue((String)"Should not find any tables", (catalog.getTables((Schema)(systemSchema = new SchemaReference("PUBLIC", "SYSTEM_LOBS"))).size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected no routines, since routine retrieval is turned off by default", (long)0L, (long)catalog.getRoutines((Schema)systemSchema).size());
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Assert.assertEquals((String)"Could not find any tables", (long)10L, (long)catalog.getTables((Schema)schema).size());
        Assert.assertEquals((String)"Expected no routines, since routine retrieval is turned off by default", (long)0L, (long)catalog.getRoutines((Schema)schema).size());
        Table table0 = (Table)catalog.getTables((Schema)schema).toArray()[0];
        Assert.assertTrue((String)"Could not find any columns", (table0.getColumns().size() > 0 ? 1 : 0) != 0);
        MutableTable table1 = new MutableTable(table0.getSchema(), "Test Table 1");
        MutableTable table2 = new MutableTable(table0.getSchema(), "Test Table 2");
        MutablePrimaryKey primaryKey = (MutablePrimaryKey)table0.getPrimaryKey();
        table1.setPrimaryKeyAndReplaceIndex(primaryKey);
        table2.setPrimaryKeyAndReplaceIndex(primaryKey);
        for (Column column : table0.getColumns()) {
            table1.addColumn((MutableColumn)column);
            table2.addColumn((MutableColumn)column);
        }
        for (Index index : table0.getIndexes()) {
            table1.addIndex((MutableIndex)index);
            table2.addIndex((MutableIndex)index);
        }
        for (ForeignKey fk : table0.getForeignKeys()) {
            table1.addForeignKey((MutableForeignKey)fk);
            table2.addForeignKey((MutableForeignKey)fk);
        }
        for (Trigger trigger : table0.getTriggers()) {
            table1.addTrigger((MutableTrigger)trigger);
            table2.addTrigger((MutableTrigger)trigger);
        }
        for (Privilege privilege : table0.getPrivileges()) {
            table1.addPrivilege((MutablePrivilege)privilege);
            table2.addPrivilege((MutablePrivilege)privilege);
        }
        for (Constraint tableConstraint : table0.getTableConstraints()) {
            table1.addTableConstraint((MutableTableConstraint)tableConstraint);
            table2.addTableConstraint((MutableTableConstraint)tableConstraint);
        }
        Assert.assertFalse((String)"Tables should not be equal", (boolean)table1.equals((Object)table2));
    }
}

