/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestName;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.utility.NamedObjectSort;
import sf.util.SchemaCrawlerLogger;

public class ExcludeTest
extends BaseDatabaseTest {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)ExcludeTest.class.getName());
    @Rule
    public TestName testName = new TestName();

    @Test
    public void excludeColumns() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT")).includeColumns((InclusionRule)new RegularExpressionExclusionRule(".*\\..*\\.ID"));
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)5L, (long)schemas.length);
            for (Schema schema : schemas) {
                out.println("schema: " + schema.getFullName());
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println("  table: " + table.getFullName());
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        LOGGER.log(Level.FINE, column.toString());
                        out.println("    column: " + column.getFullName());
                        out.println("      database type: " + column.getColumnDataType().getDatabaseSpecificTypeName());
                        out.println("      type: " + column.getColumnDataType().getJavaSqlType().getName());
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }
}

