/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.test.utility.BaseDatabaseTest;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestName;
import schemacrawler.test.utility.TestWriter;
import sf.util.SchemaCrawlerLogger;

public class ResultColumnsTest
extends BaseDatabaseTest {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)ResultColumnsTest.class.getName());
    @Rule
    public TestName testName = new TestName();

    @Test
    public void columns() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            String sql = "SELECT                                                                     PUBLIC.BOOKS.BOOKS.TITLE AS BOOK,                                         PUBLIC.BOOKS.AUTHORS.FIRSTNAME + ' ' + PUBLIC.BOOKS.AUTHORS.LASTNAME,     PUBLIC.BOOKS.BOOKS.PRICE                                                 FROM                                                                       PUBLIC.BOOKS.BOOKS                                                        INNER JOIN PUBLIC.BOOKS.BOOKAUTHORS                                         ON PUBLIC.BOOKS.BOOKS.ID = PUBLIC.BOOKS.BOOKAUTHORS.BOOKID              INNER JOIN PUBLIC.BOOKS.AUTHORS                                             ON PUBLIC.BOOKS.AUTHORS.ID = PUBLIC.BOOKS.BOOKAUTHORS.AUTHORID         ";
            try (Connection connection = this.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT                                                                     PUBLIC.BOOKS.BOOKS.TITLE AS BOOK,                                         PUBLIC.BOOKS.AUTHORS.FIRSTNAME + ' ' + PUBLIC.BOOKS.AUTHORS.LASTNAME,     PUBLIC.BOOKS.BOOKS.PRICE                                                 FROM                                                                       PUBLIC.BOOKS.BOOKS                                                        INNER JOIN PUBLIC.BOOKS.BOOKAUTHORS                                         ON PUBLIC.BOOKS.BOOKS.ID = PUBLIC.BOOKS.BOOKAUTHORS.BOOKID              INNER JOIN PUBLIC.BOOKS.AUTHORS                                             ON PUBLIC.BOOKS.AUTHORS.ID = PUBLIC.BOOKS.BOOKAUTHORS.AUTHORID         ");){
                ResultsColumn[] columns;
                ResultsColumns resultColumns = new ResultsCrawler(resultSet).crawl();
                Assert.assertNotNull((String)"Could not obtain result columns", (Object)resultColumns);
                for (ResultsColumn column : columns = resultColumns.getColumns().toArray(new ResultsColumn[0])) {
                    LOGGER.log(Level.FINE, column.toString());
                    out.println("column: " + column.getFullName());
                    out.println("  database type: " + column.getColumnDataType().getDatabaseSpecificTypeName());
                    out.println("  type: " + column.getColumnDataType().getJavaSqlType().getName());
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }
}

