/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestName;
import schemacrawler.test.utility.TestWriter;

public class SchemaCrawlerGrepTest
extends BaseDatabaseTest {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void grepColumns() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\..*\\.BOOKID")).toOptions();
            Catalog catalog = this.getCatalog(schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)6L, (long)schemas.length);
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println("    column: " + column.getFullName());
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void grepColumnsAndIncludeChildTables() throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS\\..*")).toOptions();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Schema schema = (Schema)catalog.lookupSchema("PUBLIC.BOOKS").get();
        Assert.assertNotNull((String)"Schema PUBLIC.BOOKS not found", (Object)schema);
        Assert.assertEquals((long)1L, (long)catalog.getTables(schema).size());
        Table table = (Table)catalog.lookupTable(schema, "BOOKAUTHORS").get();
        Assert.assertNotNull((String)"Table BOOKAUTHORS not found", (Object)table);
        schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.builder((SchemaCrawlerOptions)schemaCrawlerOptions).parentTableFilterDepth(1).toOptions();
        catalog = this.getCatalog(schemaCrawlerOptions);
        schema = (Schema)catalog.lookupSchema("PUBLIC.BOOKS").get();
        Assert.assertNotNull((String)"Schema PUBLIC.BOOKS not found", (Object)schema);
        Assert.assertEquals((long)3L, (long)catalog.getTables(schema).size());
        table = (Table)catalog.lookupTable(schema, "BOOKAUTHORS").get();
        Assert.assertNotNull((String)"Table BOOKAUTHORS not found", (Object)table);
        table = (Table)catalog.lookupTable(schema, "BOOKS").get();
        Assert.assertNotNull((String)"Table BOOKS not found", (Object)table);
        table = (Table)catalog.lookupTable(schema, "AUTHORS").get();
        Assert.assertNotNull((String)"Table AUTHORS not found", (Object)table);
    }

    @Test
    public void grepCombined() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\..*\\.BOOKID")).includeGreppedDefinitions((InclusionRule)new RegularExpressionInclusionRule(".*book author.*")).toOptions();
            Catalog catalog = this.getCatalog(schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)6L, (long)schemas.length);
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println("    column: " + column.getFullName());
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void grepDefinitions() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.builder().includeGreppedDefinitions((InclusionRule)new RegularExpressionInclusionRule(".*book author.*")).toOptions();
            Catalog catalog = this.getCatalog(schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)6L, (long)schemas.length);
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println("    column: " + column.getFullName());
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void grepProcedures() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().includeAllRoutines().includeGreppedRoutineColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.B_COUNT"));
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)6L, (long)schemas.length);
            for (Schema schema : schemas) {
                Routine[] routines;
                out.println("schema: " + schema.getFullName());
                for (Routine routine : routines = catalog.getRoutines(schema).toArray(new Routine[0])) {
                    RoutineColumn[] columns;
                    out.println("  routine: " + routine.getFullName());
                    for (RoutineColumn column : columns = routine.getColumns().toArray(new RoutineColumn[0])) {
                        out.println("    parameter: " + column.getFullName());
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }
}

