/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;

public class SchemaCrawlerReferenceTest
extends BaseDatabaseTest {
    @Test
    public void fkReferences() throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.withMaximumSchemaInfoLevel();
        int fkReferenceCount = 0;
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ForeignKeyColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getPrimaryKeyColumn());
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getForeignKeyColumn());
                    ++fkReferenceCount;
                }
            }
        }
        Assert.assertEquals((long)26L, (long)fkReferenceCount);
    }

    @Test
    public void fkReferencesForGreppedAndFilteredTables1() throws Exception {
        SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().includeTables((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS")).includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS\\..*"));
        SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
        int fkReferenceCount = 0;
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ForeignKeyColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getPrimaryKeyColumn(), true);
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getForeignKeyColumn());
                    ++fkReferenceCount;
                }
            }
        }
        Assert.assertEquals((long)2L, (long)fkReferenceCount);
    }

    @Test
    public void fkReferencesForGreppedAndFilteredTables2() throws Exception {
        SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().includeTables((InclusionRule)new RegularExpressionInclusionRule(".*\\.AUTHORS")).includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.AUTHORS\\..*"));
        SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
        int fkReferenceCount = 0;
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ForeignKeyColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getPrimaryKeyColumn());
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getForeignKeyColumn(), true);
                    ++fkReferenceCount;
                }
            }
        }
        Assert.assertEquals((long)1L, (long)fkReferenceCount);
    }

    @Test
    public void fkReferencesForGreppedTables1() throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS\\..*")).toOptions();
        int fkReferenceCount = 0;
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ForeignKeyColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getPrimaryKeyColumn(), false);
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getForeignKeyColumn());
                    ++fkReferenceCount;
                }
            }
        }
        Assert.assertEquals((long)2L, (long)fkReferenceCount);
    }

    @Test
    public void fkReferencesForGreppedTables2() throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.AUTHORS\\..*")).toOptions();
        int fkReferenceCount = 0;
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ForeignKeyColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getPrimaryKeyColumn());
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getForeignKeyColumn(), false);
                    ++fkReferenceCount;
                }
            }
        }
        Assert.assertEquals((long)1L, (long)fkReferenceCount);
    }

    private void assertReferencedColumnDoesNotExist(Catalog catalog, Column column, boolean assertDataNotLoaded) {
        Table table = (Table)column.getParent();
        Assert.assertNull((String)("Primary key table table should not be in the database - " + table.getName()), catalog.lookupTable(table.getSchema(), table.getName()).orElse(null));
        Assert.assertTrue((String)"Column references do not match", (column == table.lookupColumn(column.getName()).get() ? 1 : 0) != 0);
        if (assertDataNotLoaded) {
            try {
                table.getTableType();
                Assert.fail((String)"An exception should be thrown indicating that this table was not loaded from the database");
            }
            catch (NotLoadedException notLoadedException) {
                // empty catch block
            }
            try {
                column.getColumnDataType();
                Assert.fail((String)"An exception should be thrown indicating that this table was not loaded from the database");
            }
            catch (NotLoadedException notLoadedException) {
                // empty catch block
            }
        }
    }

    private void assertReferencedColumnExists(Catalog catalog, Column column) {
        Assert.assertTrue((column != null ? 1 : 0) != 0);
        Table table = (Table)column.getParent();
        Assert.assertTrue((String)("Table references do not match - " + table.getName()), (table == catalog.lookupTable(table.getSchema(), table.getName()).get() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Column references do not match", (column == table.lookupColumn(column.getName()).get() ? 1 : 0) != 0);
    }
}

