/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Constraint;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.Property;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestName;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.utility.NamedObjectSort;
import sf.util.Utility;

public class SchemaCrawlerTest
extends BaseDatabaseTest {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void columnDataTypes() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum().toOptions()).includeAllRoutines();
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            Collection columnDataTypes = catalog.getColumnDataTypes();
            Assert.assertEquals((String)"ColumnDataType count does not match", (long)30L, (long)columnDataTypes.size());
            for (ColumnDataType columnDataType : columnDataTypes) {
                Assert.assertNotNull((Object)columnDataType);
                out.println(this.printColumnDataType(columnDataType));
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void columnLookup() throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Assert.assertNotNull((Object)catalog);
        Schema schema = (Schema)catalog.lookupSchema("PUBLIC.BOOKS").get();
        Assert.assertNotNull((Object)schema);
        Table table = (Table)catalog.lookupTable(schema, "AUTHORS").get();
        Assert.assertNotNull((Object)table);
        Assert.assertNull(table.lookupColumn(null).orElse(null));
        Assert.assertNull(table.lookupColumn("").orElse(null));
        Assert.assertNull(table.lookupColumn("NO_COLUMN").orElse(null));
        Assert.assertNotNull(table.lookupColumn("ID").orElse(null));
    }

    @Test
    public void columns() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum().toOptions()).includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)5L, (long)schemas.length);
            for (Schema schema : schemas) {
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println(String.format("%s", column.getFullName()));
                        out.println(String.format("  - %s=%s", "data-type", column.getColumnDataType()));
                        out.println(String.format("  - %s=%s", "size", column.getSize()));
                        out.println(String.format("  - %s=%s", "decimal digits", column.getDecimalDigits()));
                        out.println(String.format("  - %s=%s", "width", column.getWidth()));
                        out.println(String.format("  - %s=%s", "default value", column.getDefaultValue()));
                        out.println(String.format("  - %s=%s", "auto-incremented", column.isAutoIncremented()));
                        out.println(String.format("  - %s=%s", "nullable", column.isNullable()));
                        out.println(String.format("  - %s=%s", "generated", column.isGenerated()));
                        out.println(String.format("  - %s=%s", "part of primary key", column.isPartOfPrimaryKey()));
                        out.println(String.format("  - %s=%s", "part of foreign key", column.isPartOfForeignKey()));
                        out.println(String.format("  - %s=%s", "ordinal position", column.getOrdinalPosition()));
                        out.println(String.format("  - %s=%s", "remarks", column.getRemarks()));
                        out.println(String.format("  - %s=%s", "attibutes", ""));
                        TreeMap columnAttributes = new TreeMap(column.getAttributes());
                        for (Map.Entry columnAttribute : columnAttributes.entrySet()) {
                            out.println(String.format("    ~ %s=%s", columnAttribute.getKey(), columnAttribute.getValue()));
                        }
                    }
                    out.println();
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void counts() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum().toOptions()).includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)5L, (long)schemas.length);
            for (Schema schema : schemas) {
                out.println("schema: " + schema.getFullName());
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println("  table: " + table.getFullName());
                    out.println("    # columns: " + table.getColumns().size());
                    out.println("    # constraints: " + table.getTableConstraints().size());
                    out.println("    # indexes: " + table.getIndexes().size());
                    out.println("    # foreign keys: " + table.getForeignKeys().size());
                    out.println("    # imported foreign keys: " + table.getExportedForeignKeys().size());
                    out.println("    # exported: " + table.getImportedForeignKeys().size());
                    out.println("    # privileges: " + table.getPrivileges().size());
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void databaseInfo() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum().toOptions()).includeAllRoutines();
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            DatabaseInfo databaseInfo = catalog.getDatabaseInfo();
            Collection dbProperties = databaseInfo.getProperties();
            Assert.assertEquals((String)"Database property count does not match", (long)158L, (long)dbProperties.size());
            Collection serverInfo = databaseInfo.getServerInfo();
            Assert.assertEquals((String)"Server info property count does not match", (long)0L, (long)serverInfo.size());
            out.println(String.format("username=%s", databaseInfo.getUserName()));
            out.println(String.format("product name=%s", databaseInfo.getProductName()));
            out.println(String.format("product version=%s", databaseInfo.getProductVersion()));
            out.println(String.format("catalog=%s", catalog.getName()));
            for (Property serverInfoProperty : serverInfo) {
                Assert.assertNotNull((Object)serverInfoProperty);
                out.println(serverInfoProperty);
            }
            for (DatabaseProperty dbProperty : dbProperties) {
                Assert.assertNotNull((Object)dbProperty);
                out.println(dbProperty);
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void relatedTables() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaCrawlerOptions);
            Table[] tables = catalog.getTables().toArray(new Table[0]);
            Assert.assertEquals((String)"Table count does not match", (long)13L, (long)tables.length);
            Arrays.sort(tables, NamedObjectSort.alphabetical);
            for (Table table : tables) {
                out.println("  table: " + table.getFullName());
                out.println("    # columns: " + table.getColumns().size());
                out.println("    # child tables: " + table.getRelatedTables(TableRelationshipType.child));
                out.println("    # parent tables: " + table.getRelatedTables(TableRelationshipType.parent));
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void relatedTablesWithTableRestriction() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().includeTables((InclusionRule)new RegularExpressionInclusionRule(".*\\.AUTHORS"));
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaCrawlerOptions);
            Table[] tables = catalog.getTables().toArray(new Table[0]);
            Assert.assertEquals((String)"Table count does not match", (long)1L, (long)tables.length);
            Arrays.sort(tables, NamedObjectSort.alphabetical);
            for (Table table : tables) {
                out.println("  table: " + table.getFullName());
                out.println("    # columns: " + table.getColumns().size());
                out.println("    # child tables: " + table.getRelatedTables(TableRelationshipType.child));
                out.println("    # parent tables: " + table.getRelatedTables(TableRelationshipType.parent));
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void routineDefinitions() throws Exception {
        Config config = this.loadHsqldbConfig();
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
        SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum().toOptions()).includeAllRoutines();
        SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
        Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Routine[] routines = catalog.getRoutines((Schema)schema).toArray(new Routine[0]);
        Assert.assertEquals((String)"Wrong number of routines", (long)4L, (long)routines.length);
        for (Routine routine : routines) {
            Assert.assertFalse((String)("Routine definition not found, for " + routine), (boolean)Utility.isBlank((CharSequence)routine.getDefinition()));
        }
    }

    @Test
    public void schemaEquals() throws Exception {
        SchemaReference schema1;
        SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.detailed().toOptions()).includeAllRoutines();
        SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Assert.assertTrue((String)"Could not find any tables", (catalog.getTables((Schema)(schema1 = new SchemaReference("PUBLIC", "BOOKS"))).size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong number of routines", (long)4L, (long)catalog.getRoutines((Schema)schema1).size());
        SchemaReference schema2 = new SchemaReference("PUBLIC", "BOOKS");
        Assert.assertEquals((String)"Schema not not match", (Object)schema1, (Object)schema2);
        Assert.assertEquals((String)"Tables do not match", (Object)catalog.getTables((Schema)schema1), (Object)catalog.getTables((Schema)schema2));
        Assert.assertEquals((String)"Routines do not match", (Object)catalog.getRoutines((Schema)schema1), (Object)catalog.getRoutines((Schema)schema2));
        Table table1 = catalog.getTables((Schema)schema1).toArray(new Table[0])[0];
        Table table2 = catalog.getTables((Schema)schema1).toArray(new Table[0])[1];
        Assert.assertFalse((String)"Tables should not be equal", (boolean)table1.equals(table2));
    }

    @Test
    public void sequences() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaInfoLevel minimum = SchemaInfoLevelBuilder.minimum().setRetrieveSequenceInformation(true).toOptions();
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(minimum).includeAllSequences();
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            Schema schema = (Schema)catalog.lookupSchema("PUBLIC.BOOKS").get();
            Assert.assertNotNull((String)"BOOKS Schema not found", (Object)schema);
            Sequence[] sequences = catalog.getSequences(schema).toArray(new Sequence[0]);
            Assert.assertEquals((String)"Sequence count does not match", (long)1L, (long)sequences.length);
            for (Sequence sequence : sequences) {
                Assert.assertNotNull((Object)sequence);
                out.println("sequence: " + sequence.getName());
                out.println("  increment: " + sequence.getIncrement());
                out.println("  minimum value: " + sequence.getMinimumValue());
                out.println("  maximum value: " + sequence.getMaximumValue());
                out.println("  cycle?: " + sequence.isCycle());
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void synonyms() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaInfoLevel minimum = SchemaInfoLevelBuilder.minimum().setRetrieveSynonymInformation(true).toOptions();
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(minimum).includeAllSynonyms();
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            Schema schema = (Schema)catalog.lookupSchema("PUBLIC.BOOKS").get();
            Assert.assertNotNull((String)"BOOKS Schema not found", (Object)schema);
            Synonym[] synonyms = catalog.getSynonyms(schema).toArray(new Synonym[0]);
            Assert.assertEquals((String)"Synonym count does not match", (long)1L, (long)synonyms.length);
            for (Synonym synonym : synonyms) {
                Assert.assertNotNull((Object)synonym);
                out.println("synonym: " + synonym.getName());
                out.println("  class: " + synonym.getReferencedObject().getClass().getSimpleName());
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void tableConstraints() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.withMaximumSchemaInfoLevel();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)6L, (long)schemas.length);
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = catalog.getTables(schema).toArray(new Table[0])) {
                    Constraint[] tableConstraints;
                    out.println("  table: " + table.getFullName());
                    for (Constraint tableConstraint : tableConstraints = table.getTableConstraints().toArray(new Constraint[0])) {
                        out.println("    constraint: " + tableConstraint.getName());
                        out.println("      type: " + tableConstraint.getConstraintType());
                        if (!(tableConstraint instanceof TableConstraint)) continue;
                        TableConstraint dependentTableConstraint = (TableConstraint)tableConstraint;
                        List columns = dependentTableConstraint.getColumns();
                        for (TableConstraintColumn tableConstraintColumn : columns) {
                            out.println("      on column: " + tableConstraintColumn.getName());
                        }
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void tables() throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Config config = this.loadHsqldbConfig();
            SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum().toOptions()).includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
            SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
            Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)5L, (long)schemas.length);
            for (Schema schema : schemas) {
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println(String.format("o--> %s [%s]", table.getFullName(), table.getTableType()));
                    TreeMap tableAttributes = new TreeMap(table.getAttributes());
                    for (Map.Entry tableAttribute : tableAttributes.entrySet()) {
                        out.println(String.format("      ~ %s=%s", tableAttribute.getKey(), tableAttribute.getValue()));
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(this.testName.currentMethodFullName())));
    }

    @Test
    public void tablesSort() throws Exception {
        String[] tableNames = new String[]{"AUTHORS", "BOOKS", "COUPONS", "CUSTOMERDATA", "CUSTOMERS", "Global Counts", "PUBLISHERS", "BOOKAUTHORS", "\u0392\u0399\u0392\u039b\u038a\u0391", "AUTHORSLIST"};
        Random rnd = new Random();
        SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
        SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
        Assert.assertEquals((String)"Schema count does not match", (long)5L, (long)schemas.length);
        Schema schema = schemas[0];
        for (int i = 0; i < tableNames.length; ++i) {
            String tableName1 = tableNames[i];
            for (int j = 0; j < tableNames.length; ++j) {
                String tableName2 = tableNames[j];
                Assert.assertEquals((String)(tableName1 + " <--> " + tableName2), (double)Math.signum(((Table)catalog.lookupTable(schema, tableName1).orElse(null)).compareTo(catalog.lookupTable(schema, tableName2).orElse(null))), (double)Math.signum(i - j), (double)1.0E-100);
            }
        }
        Object[] tables = catalog.getTables(schema).toArray(new Table[0]);
        for (int i = 0; i < 10; ++i) {
            for (int tableIdx = 0; tableIdx < tables.length; ++tableIdx) {
                Table table = tables[tableIdx];
                Assert.assertEquals((String)("Table name does not match in iteration " + i), (Object)tableNames[tableIdx], (Object)table.getName());
            }
            for (int k = tables.length; k > 1; --k) {
                int i1 = k - 1;
                int i2 = rnd.nextInt(k);
                Object tmp = tables[i1];
                tables[i1] = tables[i2];
                tables[i2] = tmp;
            }
            Arrays.sort(tables);
        }
    }

    @Test
    public void triggers() throws Exception {
        Config config = this.loadHsqldbConfig();
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.withMaximumSchemaInfoLevel();
        Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table[] tables = catalog.getTables((Schema)schema).toArray(new Table[0]);
        boolean foundTrigger = false;
        for (Table table : tables) {
            for (Trigger trigger : table.getTriggers()) {
                foundTrigger = true;
                Assert.assertEquals((String)"Triggers full name does not match", (Object)"PUBLIC.BOOKS.AUTHORS.TRG_AUTHORS", (Object)trigger.getFullName());
                Assert.assertEquals((String)"Trigger EventManipulationType does not match", (Object)EventManipulationType.delete, (Object)trigger.getEventManipulationType());
            }
        }
        Assert.assertTrue((String)"No triggers found", (boolean)foundTrigger);
    }

    @Test
    public void viewDefinitions() throws Exception {
        Config config = this.loadHsqldbConfig();
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions((Config)config);
        SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder();
        schemaCrawlerOptionsBuilder.tableTypes("VIEW");
        schemaCrawlerOptionsBuilder.withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum().toOptions());
        Catalog catalog = this.getCatalog(schemaRetrievalOptions, schemaCrawlerOptionsBuilder.toOptions());
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        View view = (View)catalog.lookupTable((Schema)schema, "AUTHORSLIST").get();
        Assert.assertNotNull((String)"View not found", (Object)view);
        Assert.assertNotNull((String)"View definition not found", (Object)view.getDefinition());
        Assert.assertFalse((String)"View definition not found", (boolean)view.getDefinition().trim().equals(""));
    }

    private String printColumnDataType(ColumnDataType columnDataType) {
        StringBuffer buffer = new StringBuffer();
        boolean isUserDefined = columnDataType.isUserDefined();
        String typeName = columnDataType.getFullName();
        String dataType = (isUserDefined ? "user defined " : "") + "column data-type";
        String nullable = (columnDataType.isNullable() ? "" : "not ") + "nullable";
        String autoIncrementable = (columnDataType.isAutoIncrementable() ? "" : "not ") + "auto-incrementable";
        String createParameters = columnDataType.getCreateParameters();
        String definedWith = "defined with " + (Utility.isBlank((CharSequence)createParameters) ? "no parameters" : createParameters);
        String literalPrefix = columnDataType.getLiteralPrefix();
        String literalPrefixText = Utility.isBlank((CharSequence)literalPrefix) ? "no literal prefix" : "literal prefix " + literalPrefix;
        String literalSuffix = columnDataType.getLiteralSuffix();
        String literalSuffixText = Utility.isBlank((CharSequence)literalSuffix) ? "no literal suffix" : "literal suffix " + literalSuffix;
        String javaSqlType = "java.sql.Types: " + columnDataType.getJavaSqlType().getName();
        String precision = "precision " + columnDataType.getPrecision();
        String minimumScale = "minimum scale " + columnDataType.getMinimumScale();
        String maximumScale = "maximum scale " + columnDataType.getMaximumScale();
        buffer.append(typeName).append("\n").append("  ").append(dataType).append("\n").append("  ").append(definedWith).append("\n").append("  ").append(nullable).append("\n").append("  ").append(autoIncrementable).append("\n").append("  ").append(literalPrefixText).append("\n").append("  ").append(literalSuffixText).append("\n").append("  ").append(columnDataType.getSearchable().toString()).append("\n").append("  ").append(precision).append("\n").append("  ").append(minimumScale).append("\n").append("  ").append(maximumScale).append("\n").append("  ").append(javaSqlType);
        if (isUserDefined) {
            ColumnDataType baseColumnDataType = columnDataType.getBaseType();
            String baseTypeName = baseColumnDataType == null ? "" : baseColumnDataType.getFullName();
            buffer.append("\n").append("  ").append("based on ").append(baseTypeName);
        }
        return buffer.toString();
    }
}

