/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;

public class SerializationTest
extends BaseDatabaseTest {
    @Test
    public void catalogSerialization() throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.withMaximumSchemaInfoLevel();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        Assert.assertNotNull((String)"Could not obtain catalog", (Object)catalog);
        Assert.assertTrue((String)"Could not find any schemas", (catalog.getSchemas().size() > 0 ? 1 : 0) != 0);
        Schema schema = catalog.lookupSchema("PUBLIC.BOOKS").orElse(null);
        Assert.assertNotNull((String)"Could not obtain schema", (Object)schema);
        Assert.assertEquals((String)"Unexpected number of tables in the schema", (long)10L, (long)catalog.getTables(schema).size());
        Catalog clonedCatalog = (Catalog)SerializationUtils.clone((Serializable)catalog);
        Assert.assertEquals((Object)catalog, (Object)clonedCatalog);
        Assert.assertNotNull((String)"Could not obtain catalog", (Object)clonedCatalog);
        Assert.assertTrue((String)"Could not find any schemas", (clonedCatalog.getSchemas().size() > 0 ? 1 : 0) != 0);
        Schema clonedSchema = clonedCatalog.lookupSchema("PUBLIC.BOOKS").orElse(null);
        Assert.assertNotNull((String)"Could not obtain schema", (Object)clonedSchema);
        Assert.assertEquals((String)"Unexpected number of tables in the schema", (long)10L, (long)clonedCatalog.getTables(clonedSchema).size());
    }
}

