/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;
import schemacrawler.utility.NamedObjectSort;

public class SortingTest
extends BaseDatabaseTest {
    @Test
    public void columnSort() throws Exception {
        String[] sortedNatural = new String[]{"ID", "FIRSTNAME", "LASTNAME", "ADDRESS1", "ADDRESS2", "CITY", "STATE", "POSTALCODE", "COUNTRY"};
        Object[] sortedAlpha = Arrays.copyOf(sortedNatural, sortedNatural.length);
        Arrays.sort(sortedAlpha);
        this.checkColumnSort("AUTHORS", (String[])sortedAlpha, true);
        this.checkColumnSort("AUTHORS", sortedNatural, false);
    }

    @Test
    public void fkSort() throws Exception {
        String[] sortedNatural = new String[]{"Z_FK_AUTHOR", "SYS_FK_10128"};
        Object[] sortedAlpha = Arrays.copyOf(sortedNatural, sortedNatural.length);
        Arrays.sort(sortedAlpha);
        this.checkFkSort("BOOKAUTHORS", (String[])sortedAlpha, true);
        this.checkFkSort("BOOKAUTHORS", sortedNatural, false);
    }

    @Test
    public void indexSort() throws Exception {
        String[] sortedNatural = new String[]{"SYS_IDX_PK_AUTHORS_10111", "IDX_B_AUTHORS", "IDX_A_AUTHORS"};
        Object[] sortedAlpha = Arrays.copyOf(sortedNatural, sortedNatural.length);
        Arrays.sort(sortedAlpha);
        this.checkIndexSort("AUTHORS", (String[])sortedAlpha, true);
        this.checkIndexSort("AUTHORS", sortedNatural, false);
    }

    private void checkColumnSort(String tableName, String[] expectedValues, boolean sortAlphabetically) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.withMaximumSchemaInfoLevel();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Assert.assertNotNull((String)"Schema not found", (Object)schema);
        Table table = catalog.lookupTable((Schema)schema, tableName).orElse(null);
        Assert.assertNotNull((String)("Table " + tableName + " not found"), (Object)table);
        if (table.getName().equals(tableName)) {
            Column[] columns = table.getColumns().toArray(new Column[0]);
            Arrays.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)sortAlphabetically));
            Assert.assertEquals((String)"Column count does not match", (long)expectedValues.length, (long)columns.length);
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                Assert.assertEquals((String)("Columns not " + (sortAlphabetically ? "alphabetically" : "naturally") + " sorted"), (Object)expectedValues[i], (Object)column.getName());
            }
        }
    }

    private void checkFkSort(String tableName, String[] expectedValues, boolean sortAlphabetically) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.withMaximumSchemaInfoLevel();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Assert.assertNotNull((String)"Schema not found", (Object)schema);
        Table[] tables = catalog.getTables((Schema)schema).toArray(new Table[0]);
        Assert.assertEquals((String)"Table count does not match", (long)10L, (long)tables.length);
        for (Table table : tables) {
            if (!table.getName().equals(tableName)) continue;
            ForeignKey[] foreignKeys = table.getForeignKeys().toArray(new ForeignKey[0]);
            Arrays.sort(foreignKeys, NamedObjectSort.getNamedObjectSort((boolean)sortAlphabetically));
            Assert.assertEquals((String)"Foreign key count does not match", (long)expectedValues.length, (long)foreignKeys.length);
            for (int i = 0; i < foreignKeys.length; ++i) {
                ForeignKey foreignKey = foreignKeys[i];
                Assert.assertEquals((String)("Foreign keys not " + (sortAlphabetically ? "alphabetically" : "naturally") + " sorted"), (Object)expectedValues[i], (Object)foreignKey.getName());
            }
        }
    }

    private void checkIndexSort(String tableName, String[] expectedValues, boolean sortAlphabetically) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.withMaximumSchemaInfoLevel();
        Catalog catalog = this.getCatalog(schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table[] tables = catalog.getTables((Schema)schema).toArray(new Table[0]);
        Assert.assertEquals((String)"Table count does not match", (long)10L, (long)tables.length);
        for (Table table : tables) {
            if (!table.getName().equals(tableName)) continue;
            Index[] indexes = table.getIndexes().toArray(new Index[0]);
            Arrays.sort(indexes, NamedObjectSort.getNamedObjectSort((boolean)sortAlphabetically));
            Assert.assertEquals((String)("Index count does not match for table " + table), (long)expectedValues.length, (long)indexes.length);
            for (int i = 0; i < indexes.length; ++i) {
                Index index = indexes[i];
                Assert.assertEquals((String)("Indexes not " + (sortAlphabetically ? "alphabetically" : "naturally") + " sorted  for table " + table), (Object)expectedValues[i], (Object)index.getName());
            }
        }
    }
}

