/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;
import schemacrawler.schema.TableType;
import schemacrawler.test.utility.BaseDatabaseTest;

public class TableTypeTest
extends BaseDatabaseTest {
    @Test(expected=IllegalArgumentException.class)
    public void tableTypeCompare0() throws Exception {
        new TableType(null);
    }

    @Test
    public void tableTypeCompare1() throws Exception {
        TableType tableType1 = new TableType("table");
        TableType tableType2 = new TableType("table");
        Assert.assertThat((Object)tableType1, (Matcher)OrderingComparison.comparesEqualTo((Comparable)tableType2));
        Assert.assertThat((Object)tableType2, (Matcher)OrderingComparison.comparesEqualTo((Comparable)tableType1));
        Assert.assertEquals((Object)tableType1, (Object)tableType2);
    }

    @Test
    public void tableTypeCompare2() throws Exception {
        TableType tableType1 = new TableType("table");
        TableType tableType2 = new TableType("materialized view");
        Assert.assertThat((Object)tableType1, (Matcher)OrderingComparison.lessThan((Comparable)tableType2));
        Assert.assertThat((Object)tableType2, (Matcher)OrderingComparison.greaterThan((Comparable)tableType1));
    }

    @Test
    public void tableTypeCompare3() throws Exception {
        TableType tableType1 = new TableType("view");
        TableType tableType2 = new TableType("materialized view");
        Assert.assertThat((Object)tableType1, (Matcher)OrderingComparison.lessThan((Comparable)tableType2));
        Assert.assertThat((Object)tableType2, (Matcher)OrderingComparison.greaterThan((Comparable)tableType1));
    }

    @Test
    public void tableTypeCompare4() throws Exception {
        TableType tableType1 = new TableType("table");
        TableType tableType2 = new TableType("view");
        Assert.assertThat((Object)tableType1, (Matcher)OrderingComparison.lessThan((Comparable)tableType2));
        Assert.assertThat((Object)tableType2, (Matcher)OrderingComparison.greaterThan((Comparable)tableType1));
    }
}

