/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.test.utility.BaseDatabaseTest;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.utility.NamedObjectSort;

public class TableTypesTest
extends BaseDatabaseTest {
    private static final String TABLE_TYPES_OUTPUT = "table_types/";

    @Test
    public void all() throws Exception {
        this.test("all.txt", null);
    }

    @Test
    public void bad() throws Exception {
        this.test("bad.txt", "BAD TABLE TYPE");
    }

    @Test
    public void defaultTableTypes() throws Exception {
        this.test("default.txt", "default");
    }

    @Test
    public void global_temporary() throws Exception {
        this.test("global_temporary.txt", "GLOBAL TEMPORARY");
    }

    @Test
    public void mixed() throws Exception {
        this.test("mixed.txt", " global temporary, view ");
    }

    @Test
    public void none() throws Exception {
        this.test("none.txt", "");
    }

    @Test
    public void system() throws Exception {
        this.test("system.txt", "SYSTEM TABLE");
    }

    @Test
    public void tables() throws Exception {
        this.test("tables.txt", "TABLE");
    }

    @Test
    public void views() throws Exception {
        this.test("views.txt", "VIEW");
    }

    private void test(String referenceFile, String tableTypes) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.standard().toOptions()).includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
            if (!"default".equals(tableTypes)) {
                schemaCrawlerOptionsBuilder.tableTypes(tableTypes);
            }
            Catalog catalog = this.getCatalog(schemaCrawlerOptionsBuilder.toOptions());
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            Assert.assertEquals((String)"Schema count does not match", (long)5L, (long)schemas.length);
            for (Schema schema : schemas) {
                out.println(String.format("%s", schema.getFullName()));
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println(String.format("  %s [%s]", table.getName(), table.getTableType()));
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println(String.format("    %s [%s]", column.getName(), column.getColumnDataType()));
                    }
                }
            }
        }
        Assert.assertThat((Object)FileHasContent.fileResource(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(TABLE_TYPES_OUTPUT + referenceFile)));
    }
}

