/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import sf.util.TemplatingUtility;

public class TemplatingTest {
    @Test
    public void expandTemplate() throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("one", "one.value");
        values.put("another", "two.value");
        values.put("unusual", "10");
        values.put("good", "good.value");
        values.put("split-name", "split-name value");
        String expanded = TemplatingUtility.expandTemplate((String)"No variables", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"No variables", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"${one} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"one.value variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has ${one} variable, and ${another} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has one.value variable, and two.value variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has $${unusual} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has $10 variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has ${unusual}} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has 10} variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has ${bad variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has ${bad variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has ${good} and ${bad variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has good.value and ${bad variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has ${bad and ${good} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has ${bad and ${good} variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has bad} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has bad} variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has ${undefined} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has ${undefined} variable", (Object)expanded);
        expanded = TemplatingUtility.expandTemplate((String)"Has ${split-name} variable", values);
        Assert.assertEquals((String)"Incorrect template expansion", (Object)"Has split-name value variable", (Object)expanded);
    }

    @Test
    public void extractTemplateVariables() throws Exception {
        Set variables = TemplatingUtility.extractTemplateVariables((String)"No variables");
        Assert.assertEquals((String)"Incorrect number of variables found", (long)0L, (long)variables.size());
        variables = TemplatingUtility.extractTemplateVariables((String)"${one} variable");
        List<String> sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)1L, (long)variables.size());
        Assert.assertEquals((String)"Variable not found", (Object)"one", (Object)sortedVariables.get(0));
        variables = TemplatingUtility.extractTemplateVariables((String)"Has ${one} variable, and ${another} variable");
        sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)2L, (long)variables.size());
        Assert.assertEquals((String)"Variable not found", (Object)"another", (Object)sortedVariables.get(0));
        Assert.assertEquals((String)"Variable not found", (Object)"one", (Object)sortedVariables.get(1));
        variables = TemplatingUtility.extractTemplateVariables((String)"Has $${unusual} variable");
        sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)1L, (long)variables.size());
        Assert.assertEquals((String)"Variable not found", (Object)"unusual", (Object)sortedVariables.get(0));
        variables = TemplatingUtility.extractTemplateVariables((String)"Has ${unusual}} variable");
        sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)1L, (long)variables.size());
        Assert.assertEquals((String)"Variable not found", (Object)"unusual", (Object)sortedVariables.get(0));
        variables = TemplatingUtility.extractTemplateVariables((String)"Has ${bad variable");
        sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)0L, (long)variables.size());
        variables = TemplatingUtility.extractTemplateVariables((String)"Has ${good} and ${bad variable");
        sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)1L, (long)variables.size());
        Assert.assertEquals((String)"Variable not found", (Object)"good", (Object)sortedVariables.get(0));
        variables = TemplatingUtility.extractTemplateVariables((String)"Has ${bad and ${good} variable");
        sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)1L, (long)variables.size());
        Assert.assertEquals((String)"Variable not found", (Object)"bad and ${good", (Object)sortedVariables.get(0));
        variables = TemplatingUtility.extractTemplateVariables((String)"Has bad} variable");
        sortedVariables = this.getSortedVariables(variables);
        Assert.assertEquals((String)"Incorrect number of variables found", (long)0L, (long)variables.size());
    }

    private List<String> getSortedVariables(Set<String> variables) {
        ArrayList<String> sortedVariables = new ArrayList<String>(variables);
        Collections.sort(sortedVariables);
        return sortedVariables;
    }
}

