/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import sf.util.Color;
import sf.util.RegularExpressionColorMap;

public class TestRegularExpressionColorMap {
    private static final Color test_color = Color.fromRGB((int)26, (int)59, (int)92);

    @Test
    public void badColors() {
        RegularExpressionColorMap colorMap = new RegularExpressionColorMap();
        colorMap.put("SC.*", "1A3B5");
        Assert.assertFalse((boolean)colorMap.match("SCH").isPresent());
        colorMap.put("SC.*", test_color.toString().substring(1) + "A");
        Assert.assertFalse((boolean)colorMap.match("SCH").isPresent());
        colorMap.put("SC.*", test_color.toString().substring(1));
        Assert.assertFalse((boolean)colorMap.match("SCH").isPresent());
    }

    @Test
    public void badPatterns() {
        RegularExpressionColorMap colorMap = new RegularExpressionColorMap();
        colorMap.put("SC(H", test_color.toString());
        Assert.assertFalse((boolean)colorMap.match("SCH").isPresent());
    }

    @Test
    public void fromProperties() {
        Properties properties = new Properties();
        properties.put(test_color.toString().substring(1), "SC.*");
        properties.put(test_color.toString().substring(1) + "A", "SC.*");
        properties.put("000000", "QW.*");
        RegularExpressionColorMap colorMap = new RegularExpressionColorMap(properties);
        Assert.assertEquals((long)2L, (long)colorMap.size());
        Assert.assertTrue((boolean)colorMap.match("SCH").isPresent());
        Assert.assertTrue((boolean)((Color)colorMap.match("SCH").get()).equals((Object)test_color));
        Assert.assertFalse((boolean)colorMap.match("SHC").isPresent());
        Assert.assertTrue((boolean)colorMap.match("QW").isPresent());
    }

    @Test
    public void happyPath() {
        RegularExpressionColorMap colorMap = new RegularExpressionColorMap();
        colorMap.put("SC.*", test_color.toString());
        Assert.assertTrue((boolean)colorMap.match("SCH").isPresent());
        Assert.assertTrue((boolean)((Color)colorMap.match("SCH").get()).equals((Object)test_color));
        Assert.assertTrue((boolean)colorMap.match("SC.*").isPresent());
        Assert.assertFalse((boolean)colorMap.match("SHC").isPresent());
    }

    @Test
    public void literals() {
        RegularExpressionColorMap colorMap = new RegularExpressionColorMap();
        colorMap.putLiteral("SC.*", test_color);
        Assert.assertFalse((boolean)colorMap.match("SCH").isPresent());
        Assert.assertTrue((boolean)colorMap.match("SC.*").isPresent());
    }
}

