/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.graph;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.test.graph.GraphTestBase;
import schemacrawler.test.utility.TestName;
import sf.util.graph.DirectedGraph;
import sf.util.graph.GraphException;

public class DirectedGraphTest
extends GraphTestBase {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void cycles() throws Exception {
        DirectedGraph<String> graph = this.makeGraph();
        graph.addEdge((Comparable)((Object)"C"), (Comparable)((Object)"A"));
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void noCycles() throws Exception {
        DirectedGraph<String> graph = this.makeGraph();
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void smallCycle() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"A"));
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void topologicalSort() throws Exception {
        for (int i = 0; i < 8; ++i) {
            DirectedGraph<String> graph = this.makeGraph();
            Assert.assertEquals((String)("Test run #" + (i + 1)), (Object)"[A, E, B, D, C]", (Object)this.topologicalSort(graph).toString());
        }
    }

    @Test(expected=GraphException.class)
    public void topologicalSortCyclical() throws Exception {
        DirectedGraph<String> graph = this.makeGraph();
        graph.addEdge((Comparable)((Object)"C"), (Comparable)((Object)"A"));
        Assert.assertEquals(Arrays.asList("E", "A", "D", "B", "C"), this.topologicalSort(graph));
    }

    private DirectedGraph<String> makeGraph() {
        DirectedGraph<String> graph = new DirectedGraph<String>(this.testName.currentMethodFullName()){
            {
                this.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
                this.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"C"));
                this.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"D"));
                this.addVertex((Comparable)((Object)"E"));
            }
        };
        return graph;
    }
}

