/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.graph;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.test.graph.GraphTestBase;
import schemacrawler.test.utility.TestName;
import sf.util.graph.DirectedGraph;

public class DirectedGraphTest2
extends GraphTestBase {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void dbcycles1() throws Exception {
        DirectedGraph<String> graph = new DirectedGraph<String>(this.testName.currentMethodFullName()){
            {
                this.addEdge((Comparable)((Object)"ACTIVITIES"), (Comparable)((Object)"PRODUCTION_VARIANTS"));
                this.addEdge((Comparable)((Object)"PRODUCTION_VARIANTS"), (Comparable)((Object)"ACTIVITIES"));
                this.addEdge((Comparable)((Object)"PRODUCTION_VARIANTS"), (Comparable)((Object)"TARGETGROUPS"));
                this.addEdge((Comparable)((Object)"TARGETGROUPS"), (Comparable)((Object)"ORDERS"));
                this.addEdge((Comparable)((Object)"TARGETGROUPS"), (Comparable)((Object)"ORDER_LAYOUTS"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"ACTIVITIES"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"AD_CARRIERS"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"AD_SPACES"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"PRODUCTION_VARIANTS"));
                this.addEdge((Comparable)((Object)"AD_CARRIERS"), (Comparable)((Object)"ACTIVITIES"));
                this.addEdge((Comparable)((Object)"AD_SPACES"), (Comparable)((Object)"AD_CARRIERS"));
                this.addEdge((Comparable)((Object)"ORDER_LAYOUTS"), (Comparable)((Object)"ORDERS"));
            }
        };
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void dbcycles2() throws Exception {
        DirectedGraph<String> graph = new DirectedGraph<String>(this.testName.currentMethodFullName()){
            {
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"ACTIVITIES"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"AD_CARRIERS"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"AD_SPACES"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"PRODUCTION_VARIANTS"));
                this.addEdge((Comparable)((Object)"AD_CARRIERS"), (Comparable)((Object)"ACTIVITIES"));
                this.addEdge((Comparable)((Object)"AD_SPACES"), (Comparable)((Object)"AD_CARRIERS"));
                this.addEdge((Comparable)((Object)"ORDER_LAYOUTS"), (Comparable)((Object)"ORDERS"));
            }
        };
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void dbcycles3() throws Exception {
        DirectedGraph<String> graph = new DirectedGraph<String>(this.testName.currentMethodFullName()){
            {
                this.addEdge((Comparable)((Object)"TARGETGROUPS"), (Comparable)((Object)"ORDERS"));
                this.addEdge((Comparable)((Object)"TARGETGROUPS"), (Comparable)((Object)"ORDER_LAYOUTS"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"ACTIVITIES"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"AD_CARRIERS"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"AD_SPACES"));
                this.addEdge((Comparable)((Object)"ORDERS"), (Comparable)((Object)"PRODUCTION_VARIANTS"));
                this.addEdge((Comparable)((Object)"AD_CARRIERS"), (Comparable)((Object)"ACTIVITIES"));
                this.addEdge((Comparable)((Object)"AD_SPACES"), (Comparable)((Object)"AD_CARRIERS"));
                this.addEdge((Comparable)((Object)"ORDER_LAYOUTS"), (Comparable)((Object)"ORDERS"));
            }
        };
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
    }
}

