/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.graph;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.test.graph.GraphTestBase;
import schemacrawler.test.utility.TestName;
import sf.util.graph.DirectedGraph;

public class DirectedGraphTest4
extends GraphTestBase {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void test1() throws Exception {
        DirectedGraph<Integer> graph = new DirectedGraph<Integer>(this.testName.currentMethodFullName()){
            {
                this.addEdge(Integer.valueOf(0), Integer.valueOf(1));
                this.addEdge(Integer.valueOf(0), Integer.valueOf(2));
                this.addEdge(Integer.valueOf(2), Integer.valueOf(3));
                this.addEdge(Integer.valueOf(3), Integer.valueOf(4));
                this.addEdge(Integer.valueOf(4), Integer.valueOf(2));
            }
        };
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void test2() throws Exception {
        DirectedGraph<Integer> graph = new DirectedGraph<Integer>(this.testName.currentMethodFullName()){
            {
                this.addVertex(Integer.valueOf(0));
                this.addVertex(Integer.valueOf(1));
                this.addVertex(Integer.valueOf(2));
                this.addVertex(Integer.valueOf(3));
            }
        };
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void test3() throws Exception {
        DirectedGraph<Integer> graph = new DirectedGraph<Integer>(this.testName.currentMethodFullName()){
            {
                this.addVertex(Integer.valueOf(0));
                this.addEdge(Integer.valueOf(1), Integer.valueOf(2));
                this.addEdge(Integer.valueOf(3), Integer.valueOf(4));
                this.addEdge(Integer.valueOf(4), Integer.valueOf(5));
                this.addEdge(Integer.valueOf(5), Integer.valueOf(3));
            }
        };
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void test4() throws Exception {
        DirectedGraph<Integer> graph = new DirectedGraph<Integer>(this.testName.currentMethodFullName()){
            {
                this.addEdge(Integer.valueOf(0), Integer.valueOf(1));
                this.addEdge(Integer.valueOf(0), Integer.valueOf(2));
                this.addEdge(Integer.valueOf(1), Integer.valueOf(3));
                this.addEdge(Integer.valueOf(1), Integer.valueOf(4));
                this.addEdge(Integer.valueOf(5), Integer.valueOf(6));
                this.addEdge(Integer.valueOf(5), Integer.valueOf(7));
            }
        };
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
    }
}

